/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jps.preset;

import java.io.File;
import java.util.List;
import org.openbase.jps.core.AbstractJavaProperty;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.exception.JPValidationException;
import org.openbase.jps.tools.FileHandler;

public abstract class AbstractJPFile
extends AbstractJavaProperty<File> {
    private static final String[] ARGUMENT_IDENTIFIERS = new String[]{"FILE"};
    private FileHandler.AutoMode autoCreateMode;
    private FileHandler.ExistenceHandling existenceHandling;
    private FileHandler.FileType type;

    public AbstractJPFile(String[] commandIdentifier, FileHandler.ExistenceHandling existenceHandling, FileHandler.AutoMode autoCreateMode) {
        super(commandIdentifier);
        this.existenceHandling = existenceHandling;
        this.autoCreateMode = autoCreateMode;
        this.type = FileHandler.FileType.File;
    }

    AbstractJPFile(String[] commandIdentifier, FileHandler.ExistenceHandling existenceHandling, FileHandler.AutoMode autoCreateMode, FileHandler.FileType type) {
        this(commandIdentifier, existenceHandling, autoCreateMode);
        this.type = type;
    }

    public static String convertIntoValidFileName(String filename) {
        return filename.replaceAll("[^0-9a-zA-Z-\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8\u00c9\u00c8\u00df\\.\\-\\_\\[\\]\\#\\$]+", "_");
    }

    @Override
    protected String[] generateArgumentIdentifiers() {
        return ARGUMENT_IDENTIFIERS;
    }

    @Override
    protected File parse(List<String> arguments) throws Exception {
        return new File(this.getOneArgumentResult());
    }

    @Override
    public void validate() throws JPValidationException {
        File value = (File)this.getValue();
        if (value == null) {
            throw new JPValidationException(this.getClass().getSimpleName() + " is not defined but can be set manually with " + this.getDefaultExample(), this.getErrorReport());
        }
        try {
            FileHandler.handle(value, this.type, this.existenceHandling, this.autoCreateMode);
        }
        catch (Exception ex) {
            throw new JPValidationException("Could not handle " + this.type.name() + "[" + value + "]!", ex);
        }
    }

    @Override
    protected void setValue(File value, AbstractJavaProperty.ValueType valueType) {
        if (value.isAbsolute()) {
            super.setValue(value, valueType);
            return;
        }
        try {
            File parent = this.getParentDirectory();
            if (parent == null) {
                super.setValue(value, valueType);
                return;
            }
            super.setValue(new File(parent, value.getPath()), valueType);
        }
        catch (JPServiceException ex) {
            this.addErrorReport(new JPServiceException("Parent directory is not valid!", ex), valueType);
        }
    }

    public FileHandler.AutoMode getAutoCreateMode() {
        return this.autoCreateMode;
    }

    protected void setAutoCreateMode(FileHandler.AutoMode autoCreateMode) {
        this.autoCreateMode = autoCreateMode;
    }

    public FileHandler.ExistenceHandling getExistenceHandling() {
        return this.existenceHandling;
    }

    protected void setExistenceHandling(FileHandler.ExistenceHandling existenceHandling) {
        this.existenceHandling = existenceHandling;
    }

    public FileHandler.FileType getType() {
        return this.type;
    }

    public File getParentDirectory() throws JPServiceException {
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[Type:" + (Object)((Object)this.type) + "|ExistenceHandling:" + (Object)((Object)this.existenceHandling) + "|AutoMode:" + (Object)((Object)this.autoCreateMode) + "]";
    }
}

