/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.schema.validator.JsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.AdditionalPropertiesValidator;
import org.openapi4j.schema.validator.v3.AllOfValidator;
import org.openapi4j.schema.validator.v3.AnyOfValidator;
import org.openapi4j.schema.validator.v3.DependenciesValidator;
import org.openapi4j.schema.validator.v3.EnumValidator;
import org.openapi4j.schema.validator.v3.FormatValidator;
import org.openapi4j.schema.validator.v3.ItemsValidator;
import org.openapi4j.schema.validator.v3.MaxItemsValidator;
import org.openapi4j.schema.validator.v3.MaxLengthValidator;
import org.openapi4j.schema.validator.v3.MaxPropertiesValidator;
import org.openapi4j.schema.validator.v3.MaximumValidator;
import org.openapi4j.schema.validator.v3.MinItemsValidator;
import org.openapi4j.schema.validator.v3.MinLengthValidator;
import org.openapi4j.schema.validator.v3.MinPropertiesValidator;
import org.openapi4j.schema.validator.v3.MinimumValidator;
import org.openapi4j.schema.validator.v3.MultipleOfValidator;
import org.openapi4j.schema.validator.v3.NotValidator;
import org.openapi4j.schema.validator.v3.NullableValidator;
import org.openapi4j.schema.validator.v3.OneOfValidator;
import org.openapi4j.schema.validator.v3.PatternPropertiesValidator;
import org.openapi4j.schema.validator.v3.PatternValidator;
import org.openapi4j.schema.validator.v3.PropertiesValidator;
import org.openapi4j.schema.validator.v3.ReferenceValidator;
import org.openapi4j.schema.validator.v3.RequiredValidator;
import org.openapi4j.schema.validator.v3.SchemaValidator;
import org.openapi4j.schema.validator.v3.TypeValidator;
import org.openapi4j.schema.validator.v3.UniqueItemsValidator;
import org.openapi4j.schema.validator.v3.ValidatorInstance;

class ValidatorsRegistry {
    private static final ValidatorsRegistry INSTANCE = new ValidatorsRegistry();

    private ValidatorsRegistry() {
    }

    static ValidatorsRegistry instance() {
        return INSTANCE;
    }

    Collection<JsonValidator> getValidators(ValidationContext<OAI3> context, String keyword, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        ArrayList<JsonValidator> validatorInstances = null;
        Collection additionalInstances = context.getValidators().get(keyword);
        ValidatorInstance coreInstance = this.getCoreValidator(keyword);
        if (additionalInstances != null) {
            validatorInstances = new ArrayList<JsonValidator>();
            for (ValidatorInstance additionalInstance : additionalInstances) {
                validatorInstances.add(additionalInstance.apply(context, schemaNode, schemaParentNode, parentSchema));
            }
            if (coreInstance != null) {
                validatorInstances.add(coreInstance.apply(context, schemaNode, schemaParentNode, parentSchema));
            }
        } else if (coreInstance != null) {
            validatorInstances = new ArrayList();
            validatorInstances.add(coreInstance.apply(context, schemaNode, schemaParentNode, parentSchema));
        }
        return validatorInstances;
    }

    private ValidatorInstance getCoreValidator(String keyword) {
        switch (keyword) {
            case "additionalProperties": {
                return AdditionalPropertiesValidator::new;
            }
            case "allOf": {
                return AllOfValidator::new;
            }
            case "anyOf": {
                return AnyOfValidator::new;
            }
            case "dependencies": {
                return DependenciesValidator::new;
            }
            case "enum": {
                return EnumValidator::new;
            }
            case "format": {
                return FormatValidator::new;
            }
            case "items": {
                return ItemsValidator::new;
            }
            case "maximum": {
                return MaximumValidator::new;
            }
            case "maxItems": {
                return MaxItemsValidator::new;
            }
            case "maxLength": {
                return MaxLengthValidator::new;
            }
            case "maxProperties": {
                return MaxPropertiesValidator::new;
            }
            case "minimum": {
                return MinimumValidator::new;
            }
            case "minItems": {
                return MinItemsValidator::new;
            }
            case "minLength": {
                return MinLengthValidator::new;
            }
            case "minProperties": {
                return MinPropertiesValidator::new;
            }
            case "multipleOf": {
                return MultipleOfValidator::new;
            }
            case "not": {
                return NotValidator::new;
            }
            case "nullable": {
                return NullableValidator::new;
            }
            case "oneOf": {
                return OneOfValidator::new;
            }
            case "pattern": {
                return PatternValidator::new;
            }
            case "patternProperties": {
                return PatternPropertiesValidator::new;
            }
            case "properties": {
                return PropertiesValidator::new;
            }
            case "$ref": {
                return ReferenceValidator::new;
            }
            case "required": {
                return RequiredValidator::new;
            }
            case "type": {
                return TypeValidator::new;
            }
            case "uniqueItems": {
                return UniqueItemsValidator::new;
            }
        }
        return null;
    }
}

