/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openapi4j.core.exception.ResolutionException;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.model.v3.OAI3Context;
import org.openapi4j.core.validation.ValidationException;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.JsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.ValidatorsRegistry;

public class SchemaValidator
extends BaseJsonValidator<OAI3> {
    private static final JsonNode FALSE_NODE = JsonNodeFactory.instance.booleanNode(false);
    private final ValidationResults.CrumbInfo crumbInfo;
    private final Map<String, Collection<JsonValidator>> validators;

    public SchemaValidator(String propertyName, JsonNode schemaNode) throws ResolutionException {
        this(new ValidationContext<OAI3>((OAIContext)new OAI3Context(SchemaValidator.getDefaultBaseUrl(), schemaNode)), new ValidationResults.CrumbInfo(propertyName, false), schemaNode, null, null);
    }

    public SchemaValidator(ValidationContext<OAI3> context, String propertyName, JsonNode schemaNode) {
        this(context, new ValidationResults.CrumbInfo(propertyName, false), schemaNode, null, null);
    }

    SchemaValidator(ValidationContext<OAI3> context, ValidationResults.CrumbInfo crumbInfo, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.crumbInfo = crumbInfo;
        this.validators = this.read(this.context, schemaNode);
    }

    @Override
    public boolean validate(JsonNode valueNode, ValidationData<?> validation) {
        try {
            this.validateWithContext(valueNode, validation);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return true;
    }

    public ValidationContext<OAI3> getContext() {
        return this.context;
    }

    SchemaValidator findParent() {
        return this.getParentSchema() != null ? this.getParentSchema().findParent() : this;
    }

    final void validateWithContext(JsonNode valueNode, ValidationData<?> validation) throws ValidationException {
        if (valueNode == null) {
            valueNode = JsonNodeFactory.instance.nullNode();
        }
        if (this.context.isFastFail()) {
            this.fastFailValidate(valueNode, validation);
        } else {
            this.defaultValidate(valueNode, validation);
        }
    }

    private void fastFailValidate(JsonNode valueNode, ValidationData<?> validation) throws ValidationException {
        validation.results().withCrumb(this.crumbInfo, () -> {
            block0: for (Collection<JsonValidator> keywordValidators : this.validators.values()) {
                for (JsonValidator validator : keywordValidators) {
                    boolean shouldChain = validator.validate(valueNode, validation);
                    if (!validation.isValid()) {
                        return;
                    }
                    if (shouldChain) continue;
                    continue block0;
                }
            }
        });
        if (!validation.isValid()) {
            throw new ValidationException(null, validation.results());
        }
    }

    private void defaultValidate(JsonNode valueNode, ValidationData<?> validation) {
        validation.results().withCrumb(this.crumbInfo, () -> {
            for (Collection<JsonValidator> keywordValidators : this.validators.values()) {
                for (JsonValidator validator : keywordValidators) {
                    if (!validator.validate(valueNode, validation)) break;
                }
            }
        });
    }

    private Map<String, Collection<JsonValidator>> read(ValidationContext<OAI3> context, JsonNode schemaNode) {
        HashMap<String, Collection<JsonValidator>> validatorMap = new HashMap<String, Collection<JsonValidator>>();
        Iterator fieldNames = schemaNode.fieldNames();
        while (fieldNames.hasNext()) {
            String keyword = (String)fieldNames.next();
            JsonNode keywordSchemaNode = schemaNode.get(keyword);
            Collection<JsonValidator> keywordValidators = ValidatorsRegistry.instance().getValidators(context, keyword, keywordSchemaNode, schemaNode, this);
            if (keywordValidators == null) continue;
            validatorMap.put(keyword, keywordValidators);
        }
        this.applyAdditionalValidators(validatorMap, schemaNode);
        return validatorMap;
    }

    private void applyAdditionalValidators(Map<String, Collection<JsonValidator>> validatorMap, JsonNode schemaNode) {
        if (validatorMap.containsKey("$ref")) {
            return;
        }
        if (validatorMap.get("additionalProperties") == null && this.context.getOption((byte)1)) {
            validatorMap.put("additionalProperties", ValidatorsRegistry.instance().getValidators(this.context, "additionalProperties", FALSE_NODE, schemaNode, this));
        }
        validatorMap.computeIfAbsent("nullable", s -> ValidatorsRegistry.instance().getValidators(this.context, (String)s, FALSE_NODE, schemaNode, this));
    }

    private static URL getDefaultBaseUrl() {
        try {
            return new URL("file:/");
        }
        catch (MalformedURLException ignored) {
            return null;
        }
    }
}

