/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class RequiredValidator
extends BaseJsonValidator<OAI3> {
    private static final ValidationResult ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1026), "Field '%s' is required.");
    private static final ValidationResults.CrumbInfo CRUMB_INFO = new ValidationResults.CrumbInfo("required", true);
    private final List<String> fieldNames;

    RequiredValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        if (schemaNode.isArray()) {
            this.fieldNames = new ArrayList<String>();
            for (JsonNode fieldName : schemaNode) {
                this.fieldNames.add(fieldName.asText());
            }
        } else {
            this.fieldNames = null;
        }
    }

    @Override
    public boolean validate(JsonNode valueNode, ValidationData<?> validation) {
        if (this.fieldNames == null) {
            return false;
        }
        for (String fieldName : this.fieldNames) {
            if (null != valueNode.get(fieldName)) continue;
            validation.add(CRUMB_INFO, ERR, fieldName);
        }
        return false;
    }
}

