/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class PatternValidator
extends BaseJsonValidator<OAI3> {
    private static final ValidationResult PATTERN_DEF_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1024), "Wrong pattern definition '%s'.");
    private static final ValidationResult ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1025), "'%s' does not respect pattern '%s'.");
    private static final ValidationResults.CrumbInfo CRUMB_INFO = new ValidationResults.CrumbInfo("pattern", true);
    private final String patternStr;
    private final Pattern pattern;

    PatternValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.patternStr = schemaNode.asText();
        this.pattern = schemaNode.isTextual() ? Pattern.compile(schemaNode.textValue()) : null;
    }

    @Override
    public boolean validate(JsonNode valueNode, ValidationData<?> validation) {
        if (this.pattern == null) {
            validation.add(CRUMB_INFO, PATTERN_DEF_ERR, this.patternStr);
            return false;
        }
        if (!valueNode.isTextual()) {
            return false;
        }
        String value = valueNode.textValue();
        Matcher m = this.pattern.matcher(value);
        if (!m.find()) {
            validation.add(CRUMB_INFO, ERR, value, this.patternStr);
        }
        return false;
    }
}

