/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class ItemsValidator
extends BaseJsonValidator<OAI3> {
    private static final ValidationResults.CrumbInfo CRUMB_INFO = new ValidationResults.CrumbInfo("items", true);
    private final SchemaValidator schema;

    ItemsValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.schema = new SchemaValidator(context, CRUMB_INFO, schemaNode, schemaParentNode, parentSchema);
    }

    @Override
    public boolean validate(JsonNode valueNode, ValidationData<?> validation) {
        if (!valueNode.isArray()) {
            return false;
        }
        for (int idx = 0; idx < valueNode.size(); ++idx) {
            JsonNode itemNode = valueNode.get(idx);
            validation.results().withCrumb(new ValidationResults.CrumbInfo(Integer.toString(idx), false), () -> this.schema.validate(itemNode, validation));
            if (this.context.isFastFail() && !validation.isValid()) break;
        }
        return false;
    }
}

