/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import java.util.Comparator;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class EnumValidator
extends BaseJsonValidator<OAI3> {
    private static final ValidationResult ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1006), "Value '%s' is not defined in the schema.");
    private static final ValidationResults.CrumbInfo CRUMB_INFO = new ValidationResults.CrumbInfo("enum", true);
    private final JsonNode schemaNode;
    private static final NodeComparator NODE_COMPARATOR = new NodeComparator();

    EnumValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.schemaNode = schemaNode;
    }

    @Override
    public boolean validate(JsonNode valueNode, ValidationData<?> validation) {
        if (this.schemaNode.isArray()) {
            for (JsonNode enumNode : this.schemaNode) {
                if (!enumNode.equals((Comparator)NODE_COMPARATOR, valueNode)) continue;
                return false;
            }
            validation.add(CRUMB_INFO, ERR, valueNode.asText());
        }
        return false;
    }

    private static class NodeComparator
    implements Comparator<JsonNode> {
        private NodeComparator() {
        }

        @Override
        public int compare(JsonNode n1, JsonNode n2) {
            Double d2;
            Double d1;
            if (n1.equals((Object)n2)) {
                return 0;
            }
            if (n1 instanceof NumericNode && n2 instanceof NumericNode && (d1 = Double.valueOf(n1.asDouble())).compareTo(d2 = Double.valueOf(n2.asDouble())) == 0) {
                return 0;
            }
            return 1;
        }
    }
}

