/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import org.openapi4j.core.model.reference.Reference;
import org.openapi4j.core.model.reference.ReferenceRegistry;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

abstract class DiscriminatorValidator
extends BaseJsonValidator<OAI3> {
    private static final ValidationResult INVALID_SCHEMA_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1003), "Schema selection can't be made for discriminator '%s' with value '%s'.");
    private static final ValidationResult INVALID_PROPERTY_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1004), "Property name in schema is not set.");
    private static final ValidationResult INVALID_PROPERTY_CONTENT_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1005), "Property name in content '%s' is not set.");
    private static final ValidationResults.CrumbInfo CRUMB_INFO = new ValidationResults.CrumbInfo("discriminator", true);
    private static final String SCHEMAS_PATH = "#/components/schemas/";
    final List<SchemaValidator> validators = new ArrayList<SchemaValidator>();
    private final String arrayType;
    private JsonNode discriminatorNode;
    private String discriminatorPropertyName;
    private JsonNode discriminatorMapping;
    private final ValidationResults.CrumbInfo crumbInfo;

    DiscriminatorValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema, String arrayType) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.arrayType = arrayType;
        this.crumbInfo = new ValidationResults.CrumbInfo(arrayType, true);
        this.setupDiscriminator(context, schemaNode, schemaParentNode, parentSchema);
    }

    @Override
    public boolean validate(JsonNode valueNode, ValidationData<?> validation) {
        if (this.discriminatorNode != null) {
            String discriminatorValue = this.getDiscriminatorValue(valueNode, validation);
            if (discriminatorValue != null) {
                if ("allOf".equals(this.arrayType)) {
                    this.validateAllOf(valueNode, discriminatorValue, validation);
                } else {
                    this.validateOneAnyOf(valueNode, discriminatorValue, validation);
                }
            }
        } else {
            this.validateWithoutDiscriminator(valueNode, validation);
        }
        return false;
    }

    private void validateAllOf(JsonNode valueNode, String discriminatorValue, ValidationData<?> validation) {
        if (!this.checkAllOfValidator(discriminatorValue)) {
            validation.add(CRUMB_INFO, INVALID_SCHEMA_ERR, this.discriminatorPropertyName, discriminatorValue);
            return;
        }
        this.validate(() -> {
            for (SchemaValidator validator : this.validators) {
                validator.validateWithContext(valueNode, validation);
            }
        });
    }

    private void validateOneAnyOf(JsonNode valueNode, String discriminatorValue, ValidationData<?> validation) {
        SchemaValidator validator = this.getOneAnyOfValidator(discriminatorValue);
        if (validator == null) {
            validation.add(CRUMB_INFO, INVALID_SCHEMA_ERR, this.discriminatorPropertyName, discriminatorValue);
            return;
        }
        this.validate(() -> validator.validateWithContext(valueNode, validation));
    }

    abstract void validateWithoutDiscriminator(JsonNode var1, ValidationData<?> var2);

    private void setupDiscriminator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        if ("allOf".equals(this.arrayType)) {
            this.setupAllOfDiscriminatorSchemas(context, schemaNode, schemaParentNode, parentSchema);
        } else {
            this.setupAnyOneOfDiscriminatorSchemas(context, schemaNode, schemaParentNode, parentSchema);
        }
        if (this.discriminatorNode != null) {
            JsonNode propertyNameNode = this.discriminatorNode.get("propertyName");
            if (propertyNameNode == null) {
                return;
            }
            this.discriminatorPropertyName = propertyNameNode.textValue();
            this.discriminatorMapping = this.discriminatorNode.get("mapping");
        }
    }

    private void setupAllOfDiscriminatorSchemas(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        JsonNode allOfNode = this.getParentSchemaNode().get("allOf");
        ReferenceRegistry refRegistry = context.getContext().getReferenceRegistry();
        for (JsonNode allOfNodeItem : allOfNode) {
            List<JsonNode> refNodes = this.getReferences(allOfNodeItem);
            for (JsonNode refNode : refNodes) {
                Reference reference = refRegistry.getRef(refNode.textValue());
                this.discriminatorNode = reference.getContent().get("discriminator");
                if (this.discriminatorNode == null) continue;
                this.setupAllOfDiscriminatorSchemas(schemaNode, refNode, reference, schemaParentNode, parentSchema);
                return;
            }
        }
        for (JsonNode node : schemaNode) {
            this.validators.add(new SchemaValidator(context, this.crumbInfo, node, schemaParentNode, parentSchema));
        }
    }

    private void setupAnyOneOfDiscriminatorSchemas(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        this.discriminatorNode = this.getParentSchemaNode().get("discriminator");
        for (JsonNode node : schemaNode) {
            this.validators.add(new SchemaValidator(context, this.crumbInfo, node, schemaParentNode, parentSchema));
        }
    }

    private void setupAllOfDiscriminatorSchemas(JsonNode schemaNode, JsonNode refNode, Reference reference, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        for (JsonNode node : schemaNode) {
            JsonNode refValueNode = this.getReference(node);
            if (refNode.equals((Object)refValueNode)) {
                ValidationResults.CrumbInfo refCrumbInfo = new ValidationResults.CrumbInfo(reference.getRef(), true);
                this.validators.add(new SchemaValidator(this.context, refCrumbInfo, reference.getContent(), schemaParentNode, parentSchema));
                continue;
            }
            this.validators.add(new SchemaValidator(this.context, this.crumbInfo, node, schemaParentNode, parentSchema));
        }
    }

    private List<JsonNode> getReferences(JsonNode allOfNodeItem) {
        List refNodes = allOfNodeItem.findValues("abs$ref");
        if (refNodes.isEmpty()) {
            refNodes = allOfNodeItem.findValues("$ref");
        }
        return refNodes;
    }

    private JsonNode getReference(JsonNode node) {
        JsonNode refNode = node.get("abs$ref");
        if (refNode == null) {
            refNode = node.get("$ref");
        }
        return refNode;
    }

    private String getDiscriminatorValue(JsonNode valueNode, ValidationData<?> validation) {
        if (this.discriminatorPropertyName == null) {
            validation.add(CRUMB_INFO, INVALID_PROPERTY_ERR, new Object[0]);
            return null;
        }
        JsonNode discriminatorPropertyNameNode = valueNode.get(this.discriminatorPropertyName);
        if (discriminatorPropertyNameNode == null) {
            validation.add(CRUMB_INFO, INVALID_PROPERTY_CONTENT_ERR, this.discriminatorPropertyName);
            return null;
        }
        return discriminatorPropertyNameNode.textValue();
    }

    private boolean checkAllOfValidator(String discriminatorValue) {
        JsonNode mappingNode;
        String ref = null;
        if (this.discriminatorMapping != null && (mappingNode = this.discriminatorMapping.get(discriminatorValue)) != null) {
            ref = mappingNode.textValue();
        }
        if (ref == null) {
            ref = SCHEMAS_PATH + discriminatorValue;
        }
        return this.context.getContext().getReferenceRegistry().getRef(ref) != null;
    }

    private SchemaValidator getOneAnyOfValidator(String discriminatorValue) {
        String ref;
        SchemaValidator validator;
        JsonNode mappingNode;
        if (this.discriminatorMapping != null && (mappingNode = this.discriminatorMapping.get(discriminatorValue)) != null && (validator = this.getOneAnyOfValidator(ref = mappingNode.textValue(), String::equals)) != null) {
            return validator;
        }
        return this.getOneAnyOfValidator(discriminatorValue, String::endsWith);
    }

    private SchemaValidator getOneAnyOfValidator(String value, BiPredicate<String, String> checker) {
        for (SchemaValidator validator : this.validators) {
            JsonNode refNode = validator.getSchemaNode().get("$ref");
            if (refNode == null || !checker.test(refNode.textValue(), value)) continue;
            return validator;
        }
        return null;
    }
}

