/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.sdk;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.ServiceEntityInterface;
import org.openmetadata.schema.api.configuration.pipelineServiceClient.PipelineServiceClientConfiguration;
import org.openmetadata.schema.entity.automations.Workflow;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineStatus;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineType;
import org.openmetadata.sdk.exception.PipelineServiceClientException;
import org.openmetadata.sdk.exception.PipelineServiceVersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipelineServiceClient {
    private static final Logger LOG;
    protected final String hostIp;
    protected static final String AUTH_HEADER = "Authorization";
    protected static final String CONTENT_HEADER = "Content-Type";
    protected static final String CONTENT_TYPE = "application/json";
    public static final Map<String, String> TYPE_TO_TASK;
    public static final String SERVER_VERSION;

    public PipelineServiceClient(PipelineServiceClientConfiguration pipelineServiceClientConfiguration) {
        this.hostIp = pipelineServiceClientConfiguration.getHostIp();
    }

    public final URL validateServiceURL(String serviceURL) {
        try {
            return new URL(serviceURL);
        }
        catch (MalformedURLException e) {
            throw new PipelineServiceClientException(serviceURL + " Malformed.");
        }
    }

    public final String getBasicAuthenticationHeader(String username, String password) {
        String valueToEncode = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(valueToEncode.getBytes());
    }

    public static String getServerVersion() throws IOException {
        InputStream fileInput = PipelineServiceClient.class.getResourceAsStream("/catalog/VERSION");
        Properties props = new Properties();
        props.load(fileInput);
        return props.getProperty("version", "unknown");
    }

    public final String getVersionFromString(String version) {
        if (version != null) {
            return Pattern.compile("(\\d+.\\d+.\\d+)").matcher(version).results().map(m -> m.group(1)).findFirst().orElseThrow(() -> new PipelineServiceVersionException(String.format("Cannot extract version x.y.z from %s", version)));
        }
        throw new PipelineServiceVersionException("Received version as null");
    }

    public final Boolean validServerClientVersions(String clientVersion) {
        return this.getVersionFromString(clientVersion).equals(this.getVersionFromString(SERVER_VERSION));
    }

    public final Map<String, String> getHostIp() {
        try {
            return CommonUtil.nullOrEmpty((String)this.hostIp) ? this.requestGetHostIp() : Map.of("ip", this.hostIp);
        }
        catch (Exception e) {
            LOG.error("Failed to get Pipeline Service host IP. {}", (Object)e.getMessage());
            return Map.of("ip", "Failed to find the IP of Airflow Container. Please make sure https://api.ipify.org, https://api.my-ip.io/ip reachable from your network or that the `hostIp` setting is configured.");
        }
    }

    public abstract Response getServiceStatus();

    public abstract Response runAutomationsWorkflow(Workflow var1);

    public abstract String deployPipeline(IngestionPipeline var1, ServiceEntityInterface var2);

    public abstract String runPipeline(IngestionPipeline var1, ServiceEntityInterface var2);

    public abstract String deletePipeline(IngestionPipeline var1);

    public abstract List<PipelineStatus> getQueuedPipelineStatus(IngestionPipeline var1);

    public abstract IngestionPipeline toggleIngestion(IngestionPipeline var1);

    public abstract Map<String, String> getLastIngestionLogs(IngestionPipeline var1, String var2);

    public abstract Response killIngestion(IngestionPipeline var1);

    public abstract Map<String, String> requestGetHostIp();

    static {
        String rawServerVersion;
        LOG = LoggerFactory.getLogger(PipelineServiceClient.class);
        TYPE_TO_TASK = Map.of(PipelineType.METADATA.toString(), "ingestion_task", PipelineType.PROFILER.toString(), "profiler_task", PipelineType.LINEAGE.toString(), "lineage_task", PipelineType.DBT.toString(), "dbt_task", PipelineType.USAGE.toString(), "usage_task", PipelineType.TEST_SUITE.toString(), "test_suite_task", PipelineType.DATA_INSIGHT.toString(), "data_insight_task", PipelineType.ELASTIC_SEARCH_REINDEX.toString(), "elasticsearch_reindex_task");
        try {
            rawServerVersion = PipelineServiceClient.getServerVersion();
        }
        catch (IOException e) {
            rawServerVersion = "unknown";
        }
        SERVER_VERSION = rawServerVersion;
    }
}

