/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type.csv;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.DecimalMin;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"dryRun", "status", "abortReason", "numberOfRowsProcessed", "numberOfRowsPassed", "numberOfRowsFailed", "importResultsCsv"})
public class CsvImportResult {
    @JsonProperty(value="dryRun")
    @JsonPropertyDescription(value="True if the CSV import has dryRun flag enabled")
    private Boolean dryRun;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="State of an action over API.")
    private Status status;
    @JsonProperty(value="abortReason")
    @JsonPropertyDescription(value="Reason why import was aborted. This is set only when the `status` field is set to `aborted`")
    private String abortReason;
    @JsonProperty(value="numberOfRowsProcessed")
    @JsonPropertyDescription(value="Type used to indicate row count")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") Integer numberOfRowsProcessed = 0;
    @JsonProperty(value="numberOfRowsPassed")
    @JsonPropertyDescription(value="Type used to indicate row count")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") Integer numberOfRowsPassed = 0;
    @JsonProperty(value="numberOfRowsFailed")
    @JsonPropertyDescription(value="Type used to indicate row count")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") Integer numberOfRowsFailed = 0;
    @JsonProperty(value="importResultsCsv")
    @JsonPropertyDescription(value="CSV file that captures the result of import operation.")
    private String importResultsCsv;

    @JsonProperty(value="dryRun")
    public Boolean getDryRun() {
        return this.dryRun;
    }

    @JsonProperty(value="dryRun")
    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public CsvImportResult withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @JsonProperty(value="status")
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(Status status) {
        this.status = status;
    }

    public CsvImportResult withStatus(Status status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="abortReason")
    public String getAbortReason() {
        return this.abortReason;
    }

    @JsonProperty(value="abortReason")
    public void setAbortReason(String abortReason) {
        this.abortReason = abortReason;
    }

    public CsvImportResult withAbortReason(String abortReason) {
        this.abortReason = abortReason;
        return this;
    }

    @JsonProperty(value="numberOfRowsProcessed")
    public Integer getNumberOfRowsProcessed() {
        return this.numberOfRowsProcessed;
    }

    @JsonProperty(value="numberOfRowsProcessed")
    public void setNumberOfRowsProcessed(Integer numberOfRowsProcessed) {
        this.numberOfRowsProcessed = numberOfRowsProcessed;
    }

    public CsvImportResult withNumberOfRowsProcessed(Integer numberOfRowsProcessed) {
        this.numberOfRowsProcessed = numberOfRowsProcessed;
        return this;
    }

    @JsonProperty(value="numberOfRowsPassed")
    public Integer getNumberOfRowsPassed() {
        return this.numberOfRowsPassed;
    }

    @JsonProperty(value="numberOfRowsPassed")
    public void setNumberOfRowsPassed(Integer numberOfRowsPassed) {
        this.numberOfRowsPassed = numberOfRowsPassed;
    }

    public CsvImportResult withNumberOfRowsPassed(Integer numberOfRowsPassed) {
        this.numberOfRowsPassed = numberOfRowsPassed;
        return this;
    }

    @JsonProperty(value="numberOfRowsFailed")
    public Integer getNumberOfRowsFailed() {
        return this.numberOfRowsFailed;
    }

    @JsonProperty(value="numberOfRowsFailed")
    public void setNumberOfRowsFailed(Integer numberOfRowsFailed) {
        this.numberOfRowsFailed = numberOfRowsFailed;
    }

    public CsvImportResult withNumberOfRowsFailed(Integer numberOfRowsFailed) {
        this.numberOfRowsFailed = numberOfRowsFailed;
        return this;
    }

    @JsonProperty(value="importResultsCsv")
    public String getImportResultsCsv() {
        return this.importResultsCsv;
    }

    @JsonProperty(value="importResultsCsv")
    public void setImportResultsCsv(String importResultsCsv) {
        this.importResultsCsv = importResultsCsv;
    }

    public CsvImportResult withImportResultsCsv(String importResultsCsv) {
        this.importResultsCsv = importResultsCsv;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CsvImportResult.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dryRun");
        sb.append('=');
        sb.append(this.dryRun == null ? "<null>" : this.dryRun);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("abortReason");
        sb.append('=');
        sb.append(this.abortReason == null ? "<null>" : this.abortReason);
        sb.append(',');
        sb.append("numberOfRowsProcessed");
        sb.append('=');
        sb.append(this.numberOfRowsProcessed == null ? "<null>" : this.numberOfRowsProcessed);
        sb.append(',');
        sb.append("numberOfRowsPassed");
        sb.append('=');
        sb.append(this.numberOfRowsPassed == null ? "<null>" : this.numberOfRowsPassed);
        sb.append(',');
        sb.append("numberOfRowsFailed");
        sb.append('=');
        sb.append(this.numberOfRowsFailed == null ? "<null>" : this.numberOfRowsFailed);
        sb.append(',');
        sb.append("importResultsCsv");
        sb.append('=');
        sb.append(this.importResultsCsv == null ? "<null>" : this.importResultsCsv);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.abortReason == null ? 0 : this.abortReason.hashCode());
        result = result * 31 + (this.dryRun == null ? 0 : this.dryRun.hashCode());
        result = result * 31 + (this.numberOfRowsPassed == null ? 0 : this.numberOfRowsPassed.hashCode());
        result = result * 31 + (this.numberOfRowsProcessed == null ? 0 : this.numberOfRowsProcessed.hashCode());
        result = result * 31 + (this.numberOfRowsFailed == null ? 0 : this.numberOfRowsFailed.hashCode());
        result = result * 31 + (this.importResultsCsv == null ? 0 : this.importResultsCsv.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CsvImportResult)) {
            return false;
        }
        CsvImportResult rhs = (CsvImportResult)other;
        return (this.abortReason == rhs.abortReason || this.abortReason != null && this.abortReason.equals(rhs.abortReason)) && (this.dryRun == rhs.dryRun || this.dryRun != null && this.dryRun.equals(rhs.dryRun)) && (this.numberOfRowsPassed == rhs.numberOfRowsPassed || this.numberOfRowsPassed != null && this.numberOfRowsPassed.equals(rhs.numberOfRowsPassed)) && (this.numberOfRowsProcessed == rhs.numberOfRowsProcessed || this.numberOfRowsProcessed != null && this.numberOfRowsProcessed.equals(rhs.numberOfRowsProcessed)) && (this.numberOfRowsFailed == rhs.numberOfRowsFailed || this.numberOfRowsFailed != null && this.numberOfRowsFailed.equals(rhs.numberOfRowsFailed)) && (this.importResultsCsv == rhs.importResultsCsv || this.importResultsCsv != null && this.importResultsCsv.equals(rhs.importResultsCsv)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }

    public static enum Status {
        SUCCESS("success"),
        FAILURE("failure"),
        ABORTED("aborted"),
        PARTIAL_SUCCESS("partialSuccess");

        private final String value;
        private static final Map<String, Status> CONSTANTS;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Status fromValue(String value) {
            Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Status>();
            for (Status c : Status.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

