/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type.csv;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.csv.CsvHeader;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"summary", "headers"})
public class CsvDocumentation {
    @JsonProperty(value="summary")
    @JsonPropertyDescription(value="Summary documentation for CSV file.")
    @NotNull
    private String summary;
    @JsonProperty(value="headers")
    @JsonPropertyDescription(value="Documentation for CSV file header")
    @Valid
    @NotNull
    private List<CsvHeader> headers = new ArrayList<CsvHeader>();

    @JsonProperty(value="summary")
    public String getSummary() {
        return this.summary;
    }

    @JsonProperty(value="summary")
    public void setSummary(String summary) {
        this.summary = summary;
    }

    public CsvDocumentation withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    @JsonProperty(value="headers")
    public List<CsvHeader> getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="headers")
    public void setHeaders(List<CsvHeader> headers) {
        this.headers = headers;
    }

    public CsvDocumentation withHeaders(List<CsvHeader> headers) {
        this.headers = headers;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CsvDocumentation.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("summary");
        sb.append('=');
        sb.append(this.summary == null ? "<null>" : this.summary);
        sb.append(',');
        sb.append("headers");
        sb.append('=');
        sb.append(this.headers == null ? "<null>" : this.headers);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.summary == null ? 0 : this.summary.hashCode());
        result = result * 31 + (this.headers == null ? 0 : this.headers.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CsvDocumentation)) {
            return false;
        }
        CsvDocumentation rhs = (CsvDocumentation)other;
        return (this.summary == rhs.summary || this.summary != null && this.summary.equals(rhs.summary)) && (this.headers == rhs.headers || this.headers != null && this.headers.equals(rhs.headers));
    }
}

