/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ThreadType {
    Conversation("Conversation"),
    Task("Task"),
    Announcement("Announcement");

    private final String value;
    private static final Map<String, ThreadType> CONSTANTS;

    private ThreadType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ThreadType fromValue(String value) {
        ThreadType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ThreadType>();
        for (ThreadType c : ThreadType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

