/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TaskStatus;
import org.openmetadata.schema.type.TaskType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "type", "assignees", "status", "closedBy", "closedAt", "oldValue", "suggestion", "newValue"})
public class TaskDetails {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique identifier that identifies the task.")
    @NotNull
    private Integer id;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Type of a task.")
    @NotNull
    private TaskType type;
    @JsonProperty(value="assignees")
    @Valid
    @NotNull
    private List<EntityReference> assignees = null;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="Status of a task.")
    private TaskStatus status = TaskStatus.fromValue("Open");
    @JsonProperty(value="closedBy")
    @JsonPropertyDescription(value="The user that closed the task.")
    private String closedBy;
    @JsonProperty(value="closedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long closedAt;
    @JsonProperty(value="oldValue")
    @JsonPropertyDescription(value="The value of old object for which the task is created.")
    private String oldValue;
    @JsonProperty(value="suggestion")
    @JsonPropertyDescription(value="The suggestion object to replace the old value for which the task is created.")
    private String suggestion;
    @JsonProperty(value="newValue")
    @JsonPropertyDescription(value="The new value object that was accepted to complete the task.")
    private String newValue;

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    public TaskDetails withId(Integer id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="type")
    public TaskType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(TaskType type) {
        this.type = type;
    }

    public TaskDetails withType(TaskType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="assignees")
    public List<EntityReference> getAssignees() {
        return this.assignees;
    }

    @JsonProperty(value="assignees")
    public void setAssignees(List<EntityReference> assignees) {
        this.assignees = assignees;
    }

    public TaskDetails withAssignees(List<EntityReference> assignees) {
        this.assignees = assignees;
        return this;
    }

    @JsonProperty(value="status")
    public TaskStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    public TaskDetails withStatus(TaskStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="closedBy")
    public String getClosedBy() {
        return this.closedBy;
    }

    @JsonProperty(value="closedBy")
    public void setClosedBy(String closedBy) {
        this.closedBy = closedBy;
    }

    public TaskDetails withClosedBy(String closedBy) {
        this.closedBy = closedBy;
        return this;
    }

    @JsonProperty(value="closedAt")
    public Long getClosedAt() {
        return this.closedAt;
    }

    @JsonProperty(value="closedAt")
    public void setClosedAt(Long closedAt) {
        this.closedAt = closedAt;
    }

    public TaskDetails withClosedAt(Long closedAt) {
        this.closedAt = closedAt;
        return this;
    }

    @JsonProperty(value="oldValue")
    public String getOldValue() {
        return this.oldValue;
    }

    @JsonProperty(value="oldValue")
    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public TaskDetails withOldValue(String oldValue) {
        this.oldValue = oldValue;
        return this;
    }

    @JsonProperty(value="suggestion")
    public String getSuggestion() {
        return this.suggestion;
    }

    @JsonProperty(value="suggestion")
    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public TaskDetails withSuggestion(String suggestion) {
        this.suggestion = suggestion;
        return this;
    }

    @JsonProperty(value="newValue")
    public String getNewValue() {
        return this.newValue;
    }

    @JsonProperty(value="newValue")
    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public TaskDetails withNewValue(String newValue) {
        this.newValue = newValue;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TaskDetails.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("assignees");
        sb.append('=');
        sb.append(this.assignees == null ? "<null>" : this.assignees);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("closedBy");
        sb.append('=');
        sb.append(this.closedBy == null ? "<null>" : this.closedBy);
        sb.append(',');
        sb.append("closedAt");
        sb.append('=');
        sb.append(this.closedAt == null ? "<null>" : this.closedAt);
        sb.append(',');
        sb.append("oldValue");
        sb.append('=');
        sb.append(this.oldValue == null ? "<null>" : this.oldValue);
        sb.append(',');
        sb.append("suggestion");
        sb.append('=');
        sb.append(this.suggestion == null ? "<null>" : this.suggestion);
        sb.append(',');
        sb.append("newValue");
        sb.append('=');
        sb.append(this.newValue == null ? "<null>" : this.newValue);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.closedBy == null ? 0 : this.closedBy.hashCode());
        result = result * 31 + (this.newValue == null ? 0 : this.newValue.hashCode());
        result = result * 31 + (this.suggestion == null ? 0 : this.suggestion.hashCode());
        result = result * 31 + (this.assignees == null ? 0 : this.assignees.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.oldValue == null ? 0 : this.oldValue.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.closedAt == null ? 0 : this.closedAt.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TaskDetails)) {
            return false;
        }
        TaskDetails rhs = (TaskDetails)other;
        return (this.closedBy == rhs.closedBy || this.closedBy != null && this.closedBy.equals(rhs.closedBy)) && (this.newValue == rhs.newValue || this.newValue != null && this.newValue.equals(rhs.newValue)) && (this.suggestion == rhs.suggestion || this.suggestion != null && this.suggestion.equals(rhs.suggestion)) && (this.assignees == rhs.assignees || this.assignees != null && this.assignees.equals(rhs.assignees)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.oldValue == rhs.oldValue || this.oldValue != null && this.oldValue.equals(rhs.oldValue)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.closedAt == rhs.closedAt || this.closedAt != null && this.closedAt.equals(rhs.closedAt)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }
}

