/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"tagFQN", "description", "source", "labelType", "state", "href"})
public class TagLabel {
    @JsonProperty(value="tagFQN")
    @Size(max=128)
    @NotNull
    private @Size(max=128) @NotNull String tagFQN;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="source")
    @NotNull
    private TagSource source = TagSource.fromValue("Classification");
    @JsonProperty(value="labelType")
    @JsonPropertyDescription(value="Label type describes how a tag label was applied. 'Manual' indicates the tag label was applied by a person. 'Derived' indicates a tag label was derived using the associated tag relationship (see Classification.json for more details). 'Propagated` indicates a tag label was propagated from upstream based on lineage. 'Automated' is used when a tool was used to determine the tag label.")
    @NotNull
    private LabelType labelType = LabelType.fromValue("Manual");
    @JsonProperty(value="state")
    @JsonPropertyDescription(value="'Suggested' state is used when a tag label is suggested by users or tools. Owner of the entity must confirm the suggested labels before it is marked as 'Confirmed'.")
    @NotNull
    private State state = State.fromValue("Confirmed");
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;

    @JsonProperty(value="tagFQN")
    public String getTagFQN() {
        return this.tagFQN;
    }

    @JsonProperty(value="tagFQN")
    public void setTagFQN(String tagFQN) {
        this.tagFQN = tagFQN;
    }

    public TagLabel withTagFQN(String tagFQN) {
        this.tagFQN = tagFQN;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public TagLabel withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="source")
    public TagSource getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(TagSource source) {
        this.source = source;
    }

    public TagLabel withSource(TagSource source) {
        this.source = source;
        return this;
    }

    @JsonProperty(value="labelType")
    public LabelType getLabelType() {
        return this.labelType;
    }

    @JsonProperty(value="labelType")
    public void setLabelType(LabelType labelType) {
        this.labelType = labelType;
    }

    public TagLabel withLabelType(LabelType labelType) {
        this.labelType = labelType;
        return this;
    }

    @JsonProperty(value="state")
    public State getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    public void setState(State state) {
        this.state = state;
    }

    public TagLabel withState(State state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public TagLabel withHref(URI href) {
        this.href = href;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TagLabel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("tagFQN");
        sb.append('=');
        sb.append(this.tagFQN == null ? "<null>" : this.tagFQN);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("source");
        sb.append('=');
        sb.append(this.source == null ? "<null>" : this.source);
        sb.append(',');
        sb.append("labelType");
        sb.append('=');
        sb.append(this.labelType == null ? "<null>" : this.labelType);
        sb.append(',');
        sb.append("state");
        sb.append('=');
        sb.append(this.state == null ? "<null>" : this.state);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.tagFQN == null ? 0 : this.tagFQN.hashCode());
        result = result * 31 + (this.labelType == null ? 0 : this.labelType.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.source == null ? 0 : this.source.hashCode());
        result = result * 31 + (this.state == null ? 0 : this.state.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TagLabel)) {
            return false;
        }
        TagLabel rhs = (TagLabel)other;
        return (this.tagFQN == rhs.tagFQN || this.tagFQN != null && this.tagFQN.equals(rhs.tagFQN)) && (this.labelType == rhs.labelType || this.labelType != null && this.labelType.equals((Object)rhs.labelType)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.source == rhs.source || this.source != null && this.source.equals((Object)rhs.source)) && (this.state == rhs.state || this.state != null && this.state.equals((Object)rhs.state)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href));
    }

    public static enum TagSource {
        CLASSIFICATION("Classification"),
        GLOSSARY("Glossary");

        private final String value;
        private static final Map<String, TagSource> CONSTANTS;

        private TagSource(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TagSource fromValue(String value) {
            TagSource constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TagSource>();
            for (TagSource c : TagSource.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum State {
        SUGGESTED("Suggested"),
        CONFIRMED("Confirmed");

        private final String value;
        private static final Map<String, State> CONSTANTS;

        private State(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static State fromValue(String value) {
            State constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, State>();
            for (State c : State.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum LabelType {
        MANUAL("Manual"),
        PROPAGATED("Propagated"),
        AUTOMATED("Automated"),
        DERIVED("Derived");

        private final String value;
        private static final Map<String, LabelType> CONSTANTS;

        private LabelType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static LabelType fromValue(String value) {
            LabelType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, LabelType>();
            for (LabelType c : LabelType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

