/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"query", "userName", "startTime", "endTime", "analysisDate", "aborted", "serviceName", "databaseName", "databaseSchema", "duration"})
public class TableQuery__1 {
    @JsonProperty(value="query")
    @JsonPropertyDescription(value="SQL query")
    @NotNull
    private String query;
    @JsonProperty(value="userName")
    @JsonPropertyDescription(value="Name of the user that executed the SQL query")
    private String userName;
    @JsonProperty(value="startTime")
    @JsonPropertyDescription(value="Start time of execution of SQL query")
    private String startTime;
    @JsonProperty(value="endTime")
    @JsonPropertyDescription(value="End time of execution of SQL query")
    private String endTime;
    @JsonProperty(value="analysisDate")
    @JsonPropertyDescription(value="Date and time in ISO 8601 format. Example - '2018-11-13T20:20:39+00:00'.")
    private Date analysisDate;
    @JsonProperty(value="aborted")
    @JsonPropertyDescription(value="Flag to check if query was aborted during execution")
    private Boolean aborted;
    @JsonProperty(value="serviceName")
    @JsonPropertyDescription(value="Name that identifies this database service.")
    @NotNull
    private String serviceName;
    @JsonProperty(value="databaseName")
    @JsonPropertyDescription(value="Database associated with the table in the query")
    private String databaseName;
    @JsonProperty(value="databaseSchema")
    @JsonPropertyDescription(value="Database schema of the associated with query")
    private String databaseSchema;
    @JsonProperty(value="duration")
    @JsonPropertyDescription(value="How long did the query took to run in seconds.")
    private Double duration;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="query")
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="query")
    public void setQuery(String query) {
        this.query = query;
    }

    public TableQuery__1 withQuery(String query) {
        this.query = query;
        return this;
    }

    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public TableQuery__1 withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @JsonProperty(value="startTime")
    public String getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="startTime")
    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public TableQuery__1 withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @JsonProperty(value="endTime")
    public String getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="endTime")
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public TableQuery__1 withEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @JsonProperty(value="analysisDate")
    public Date getAnalysisDate() {
        return this.analysisDate;
    }

    @JsonProperty(value="analysisDate")
    public void setAnalysisDate(Date analysisDate) {
        this.analysisDate = analysisDate;
    }

    public TableQuery__1 withAnalysisDate(Date analysisDate) {
        this.analysisDate = analysisDate;
        return this;
    }

    @JsonProperty(value="aborted")
    public Boolean getAborted() {
        return this.aborted;
    }

    @JsonProperty(value="aborted")
    public void setAborted(Boolean aborted) {
        this.aborted = aborted;
    }

    public TableQuery__1 withAborted(Boolean aborted) {
        this.aborted = aborted;
        return this;
    }

    @JsonProperty(value="serviceName")
    public String getServiceName() {
        return this.serviceName;
    }

    @JsonProperty(value="serviceName")
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public TableQuery__1 withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @JsonProperty(value="databaseName")
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty(value="databaseName")
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public TableQuery__1 withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @JsonProperty(value="databaseSchema")
    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    @JsonProperty(value="databaseSchema")
    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public TableQuery__1 withDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
        return this;
    }

    @JsonProperty(value="duration")
    public Double getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public TableQuery__1 withDuration(Double duration) {
        this.duration = duration;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TableQuery__1 withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TableQuery__1.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("query");
        sb.append('=');
        sb.append(this.query == null ? "<null>" : this.query);
        sb.append(',');
        sb.append("userName");
        sb.append('=');
        sb.append(this.userName == null ? "<null>" : this.userName);
        sb.append(',');
        sb.append("startTime");
        sb.append('=');
        sb.append(this.startTime == null ? "<null>" : this.startTime);
        sb.append(',');
        sb.append("endTime");
        sb.append('=');
        sb.append(this.endTime == null ? "<null>" : this.endTime);
        sb.append(',');
        sb.append("analysisDate");
        sb.append('=');
        sb.append(this.analysisDate == null ? "<null>" : this.analysisDate);
        sb.append(',');
        sb.append("aborted");
        sb.append('=');
        sb.append(this.aborted == null ? "<null>" : this.aborted);
        sb.append(',');
        sb.append("serviceName");
        sb.append('=');
        sb.append(this.serviceName == null ? "<null>" : this.serviceName);
        sb.append(',');
        sb.append("databaseName");
        sb.append('=');
        sb.append(this.databaseName == null ? "<null>" : this.databaseName);
        sb.append(',');
        sb.append("databaseSchema");
        sb.append('=');
        sb.append(this.databaseSchema == null ? "<null>" : this.databaseSchema);
        sb.append(',');
        sb.append("duration");
        sb.append('=');
        sb.append(this.duration == null ? "<null>" : this.duration);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.databaseSchema == null ? 0 : this.databaseSchema.hashCode());
        result = result * 31 + (this.duration == null ? 0 : this.duration.hashCode());
        result = result * 31 + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        result = result * 31 + (this.aborted == null ? 0 : this.aborted.hashCode());
        result = result * 31 + (this.query == null ? 0 : this.query.hashCode());
        result = result * 31 + (this.analysisDate == null ? 0 : this.analysisDate.hashCode());
        result = result * 31 + (this.startTime == null ? 0 : this.startTime.hashCode());
        result = result * 31 + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.userName == null ? 0 : this.userName.hashCode());
        result = result * 31 + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TableQuery__1)) {
            return false;
        }
        TableQuery__1 rhs = (TableQuery__1)other;
        return (this.databaseSchema == rhs.databaseSchema || this.databaseSchema != null && this.databaseSchema.equals(rhs.databaseSchema)) && (this.duration == rhs.duration || this.duration != null && this.duration.equals(rhs.duration)) && (this.databaseName == rhs.databaseName || this.databaseName != null && this.databaseName.equals(rhs.databaseName)) && (this.aborted == rhs.aborted || this.aborted != null && this.aborted.equals(rhs.aborted)) && (this.query == rhs.query || this.query != null && this.query.equals(rhs.query)) && (this.analysisDate == rhs.analysisDate || this.analysisDate != null && this.analysisDate.equals(rhs.analysisDate)) && (this.startTime == rhs.startTime || this.startTime != null && this.startTime.equals(rhs.startTime)) && (this.endTime == rhs.endTime || this.endTime != null && this.endTime.equals(rhs.endTime)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.userName == rhs.userName || this.userName != null && this.userName.equals(rhs.userName)) && (this.serviceName == rhs.serviceName || this.serviceName != null && this.serviceName.equals(rhs.serviceName));
    }
}

