/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.TableProfilerConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"timestamp", "profileSample", "profileSampleType", "columnCount", "rowCount"})
public class TableProfile {
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    @NotNull
    private Long timestamp;
    @JsonProperty(value="profileSample")
    @JsonPropertyDescription(value="Percentage of data or no. of rows we want to execute the profiler and tests on")
    private Double profileSample = null;
    @JsonProperty(value="profileSampleType")
    @JsonPropertyDescription(value="Type of Profile Sample (percentage or rows)")
    private TableProfilerConfig.ProfileSampleType profileSampleType = TableProfilerConfig.ProfileSampleType.fromValue("PERCENTAGE");
    @JsonProperty(value="columnCount")
    @JsonPropertyDescription(value="No.of columns in the table.")
    private Double columnCount;
    @JsonProperty(value="rowCount")
    @JsonPropertyDescription(value="No.of rows in the table. This is always executed on the whole table.")
    private Double rowCount;

    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public TableProfile withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="profileSample")
    public Double getProfileSample() {
        return this.profileSample;
    }

    @JsonProperty(value="profileSample")
    public void setProfileSample(Double profileSample) {
        this.profileSample = profileSample;
    }

    public TableProfile withProfileSample(Double profileSample) {
        this.profileSample = profileSample;
        return this;
    }

    @JsonProperty(value="profileSampleType")
    public TableProfilerConfig.ProfileSampleType getProfileSampleType() {
        return this.profileSampleType;
    }

    @JsonProperty(value="profileSampleType")
    public void setProfileSampleType(TableProfilerConfig.ProfileSampleType profileSampleType) {
        this.profileSampleType = profileSampleType;
    }

    public TableProfile withProfileSampleType(TableProfilerConfig.ProfileSampleType profileSampleType) {
        this.profileSampleType = profileSampleType;
        return this;
    }

    @JsonProperty(value="columnCount")
    public Double getColumnCount() {
        return this.columnCount;
    }

    @JsonProperty(value="columnCount")
    public void setColumnCount(Double columnCount) {
        this.columnCount = columnCount;
    }

    public TableProfile withColumnCount(Double columnCount) {
        this.columnCount = columnCount;
        return this;
    }

    @JsonProperty(value="rowCount")
    public Double getRowCount() {
        return this.rowCount;
    }

    @JsonProperty(value="rowCount")
    public void setRowCount(Double rowCount) {
        this.rowCount = rowCount;
    }

    public TableProfile withRowCount(Double rowCount) {
        this.rowCount = rowCount;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TableProfile.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("profileSample");
        sb.append('=');
        sb.append(this.profileSample == null ? "<null>" : this.profileSample);
        sb.append(',');
        sb.append("profileSampleType");
        sb.append('=');
        sb.append(this.profileSampleType == null ? "<null>" : this.profileSampleType);
        sb.append(',');
        sb.append("columnCount");
        sb.append('=');
        sb.append(this.columnCount == null ? "<null>" : this.columnCount);
        sb.append(',');
        sb.append("rowCount");
        sb.append('=');
        sb.append(this.rowCount == null ? "<null>" : this.rowCount);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.columnCount == null ? 0 : this.columnCount.hashCode());
        result = result * 31 + (this.rowCount == null ? 0 : this.rowCount.hashCode());
        result = result * 31 + (this.profileSample == null ? 0 : this.profileSample.hashCode());
        result = result * 31 + (this.profileSampleType == null ? 0 : this.profileSampleType.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TableProfile)) {
            return false;
        }
        TableProfile rhs = (TableProfile)other;
        return (this.columnCount == rhs.columnCount || this.columnCount != null && this.columnCount.equals(rhs.columnCount)) && (this.rowCount == rhs.rowCount || this.rowCount != null && this.rowCount.equals(rhs.rowCount)) && (this.profileSample == rhs.profileSample || this.profileSample != null && this.profileSample.equals(rhs.profileSample)) && (this.profileSampleType == rhs.profileSampleType || this.profileSampleType != null && this.profileSampleType.equals((Object)rhs.profileSampleType)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }
}

