/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.openmetadata.schema.type.ColumnJoin;
import org.openmetadata.schema.type.JoinedWith;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"startDate", "dayCount", "columnJoins", "directTableJoins"})
public class TableJoins {
    @JsonProperty(value="startDate")
    @JsonPropertyDescription(value="Date in ISO 8601 format in UTC. Example - '2018-11-13'.")
    private String startDate;
    @JsonProperty(value="dayCount")
    private Integer dayCount = 1;
    @JsonProperty(value="columnJoins")
    @Valid
    private List<ColumnJoin> columnJoins = new ArrayList<ColumnJoin>();
    @JsonProperty(value="directTableJoins")
    @JsonPropertyDescription(value="Joins with other tables that are not on a specific column (e.g: UNION join)")
    @Valid
    private List<JoinedWith> directTableJoins = new ArrayList<JoinedWith>();

    @JsonProperty(value="startDate")
    public String getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public TableJoins withStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty(value="dayCount")
    public Integer getDayCount() {
        return this.dayCount;
    }

    @JsonProperty(value="dayCount")
    public void setDayCount(Integer dayCount) {
        this.dayCount = dayCount;
    }

    public TableJoins withDayCount(Integer dayCount) {
        this.dayCount = dayCount;
        return this;
    }

    @JsonProperty(value="columnJoins")
    public List<ColumnJoin> getColumnJoins() {
        return this.columnJoins;
    }

    @JsonProperty(value="columnJoins")
    public void setColumnJoins(List<ColumnJoin> columnJoins) {
        this.columnJoins = columnJoins;
    }

    public TableJoins withColumnJoins(List<ColumnJoin> columnJoins) {
        this.columnJoins = columnJoins;
        return this;
    }

    @JsonProperty(value="directTableJoins")
    public List<JoinedWith> getDirectTableJoins() {
        return this.directTableJoins;
    }

    @JsonProperty(value="directTableJoins")
    public void setDirectTableJoins(List<JoinedWith> directTableJoins) {
        this.directTableJoins = directTableJoins;
    }

    public TableJoins withDirectTableJoins(List<JoinedWith> directTableJoins) {
        this.directTableJoins = directTableJoins;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TableJoins.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("dayCount");
        sb.append('=');
        sb.append(this.dayCount == null ? "<null>" : this.dayCount);
        sb.append(',');
        sb.append("columnJoins");
        sb.append('=');
        sb.append(this.columnJoins == null ? "<null>" : this.columnJoins);
        sb.append(',');
        sb.append("directTableJoins");
        sb.append('=');
        sb.append(this.directTableJoins == null ? "<null>" : this.directTableJoins);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.directTableJoins == null ? 0 : this.directTableJoins.hashCode());
        result = result * 31 + (this.dayCount == null ? 0 : this.dayCount.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.columnJoins == null ? 0 : this.columnJoins.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TableJoins)) {
            return false;
        }
        TableJoins rhs = (TableJoins)other;
        return (this.directTableJoins == rhs.directTableJoins || this.directTableJoins != null && this.directTableJoins.equals(rhs.directTableJoins)) && (this.dayCount == rhs.dayCount || this.dayCount != null && this.dayCount.equals(rhs.dayCount)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate)) && (this.columnJoins == rhs.columnJoins || this.columnJoins != null && this.columnJoins.equals(rhs.columnJoins));
    }
}

