/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.openmetadata.schema.type.MetadataOperation;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "operations"})
public class ResourceDescriptor {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the resource. For entity related resources, resource name is same as the entity name. Some resources such as lineage are not entities but are resources.")
    private String name;
    @JsonProperty(value="operations")
    @JsonPropertyDescription(value="List of operations supported by the resource.")
    @Valid
    private List<MetadataOperation> operations = new ArrayList<MetadataOperation>();

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public ResourceDescriptor withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="operations")
    public List<MetadataOperation> getOperations() {
        return this.operations;
    }

    @JsonProperty(value="operations")
    public void setOperations(List<MetadataOperation> operations) {
        this.operations = operations;
    }

    public ResourceDescriptor withOperations(List<MetadataOperation> operations) {
        this.operations = operations;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ResourceDescriptor.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("operations");
        sb.append('=');
        sb.append(this.operations == null ? "<null>" : this.operations);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.operations == null ? 0 : this.operations.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ResourceDescriptor)) {
            return false;
        }
        ResourceDescriptor rhs = (ResourceDescriptor)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.operations == rhs.operations || this.operations != null && this.operations.equals(rhs.operations));
    }
}

