/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Relationship {
    CONTAINS("contains"),
    CREATED("createdBy"),
    REPLIED_TO("repliedTo"),
    IS_ABOUT("isAbout"),
    ADDRESSED_TO("addressedTo"),
    MENTIONED_IN("mentionedIn"),
    TESTED_BY("testedBy"),
    USES("uses"),
    OWNS("owns"),
    PARENT_OF("parentOf"),
    HAS("has"),
    FOLLOWS("follows"),
    JOINED_WITH("joinedWith"),
    UPSTREAM("upstream"),
    APPLIED_TO("appliedTo"),
    RELATED_TO("relatedTo"),
    REVIEWS("reviews"),
    REACTED_TO("reactedTo"),
    VOTED("voted");

    private final String value;
    private static final Map<String, Relationship> CONSTANTS;

    private Relationship(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Relationship fromValue(String value) {
        Relationship constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Relationship>();
        for (Relationship c : Relationship.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

