/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.ReactionType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"reactionType", "user"})
public class Reaction {
    @JsonProperty(value="reactionType")
    @JsonPropertyDescription(value="Type of reaction.")
    @NotNull
    private ReactionType reactionType;
    @JsonProperty(value="user")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    @NotNull
    private EntityReference user;

    @JsonProperty(value="reactionType")
    public ReactionType getReactionType() {
        return this.reactionType;
    }

    @JsonProperty(value="reactionType")
    public void setReactionType(ReactionType reactionType) {
        this.reactionType = reactionType;
    }

    public Reaction withReactionType(ReactionType reactionType) {
        this.reactionType = reactionType;
        return this;
    }

    @JsonProperty(value="user")
    public EntityReference getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    public void setUser(EntityReference user) {
        this.user = user;
    }

    public Reaction withUser(EntityReference user) {
        this.user = user;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Reaction.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("reactionType");
        sb.append('=');
        sb.append(this.reactionType == null ? "<null>" : this.reactionType);
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(this.user == null ? "<null>" : this.user);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.reactionType == null ? 0 : this.reactionType.hashCode());
        result = result * 31 + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Reaction)) {
            return false;
        }
        Reaction rhs = (Reaction)other;
        return (this.reactionType == rhs.reactionType || this.reactionType != null && this.reactionType.equals((Object)rhs.reactionType)) && (this.user == rhs.user || this.user != null && this.user.equals(rhs.user));
    }
}

