/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.entity.policies.accessControl.Rule;
import org.openmetadata.schema.type.MetadataOperation;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"operation", "access", "rule", "policy", "role"})
public class Permission {
    @JsonProperty(value="operation")
    @JsonPropertyDescription(value="This schema defines all possible operations on metadata of entities in OpenMetadata.")
    private MetadataOperation operation;
    @JsonProperty(value="access")
    @JsonPropertyDescription(value="Access decided after evaluating rules in a policy. Note the access is defined in the order of precedence.")
    private Access access;
    @JsonProperty(value="rule")
    @JsonPropertyDescription(value="Describes an Access Control Rule for OpenMetadata Metadata Operations. All non-null user (subject) and entity (object) attributes are evaluated with logical AND.")
    @Valid
    private Rule rule;
    @JsonProperty(value="policy")
    @JsonPropertyDescription(value="Name of the policy where the `rule` is from.")
    private String policy;
    @JsonProperty(value="role")
    @JsonPropertyDescription(value="Name of the role where the `policy` is from. If this is not role based policy, `role` is set to null")
    private String role;

    @JsonProperty(value="operation")
    public MetadataOperation getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    public void setOperation(MetadataOperation operation) {
        this.operation = operation;
    }

    public Permission withOperation(MetadataOperation operation) {
        this.operation = operation;
        return this;
    }

    @JsonProperty(value="access")
    public Access getAccess() {
        return this.access;
    }

    @JsonProperty(value="access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public Permission withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty(value="rule")
    public Rule getRule() {
        return this.rule;
    }

    @JsonProperty(value="rule")
    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public Permission withRule(Rule rule) {
        this.rule = rule;
        return this;
    }

    @JsonProperty(value="policy")
    public String getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public Permission withPolicy(String policy) {
        this.policy = policy;
        return this;
    }

    @JsonProperty(value="role")
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    public void setRole(String role) {
        this.role = role;
    }

    public Permission withRole(String role) {
        this.role = role;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Permission.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("operation");
        sb.append('=');
        sb.append(this.operation == null ? "<null>" : this.operation);
        sb.append(',');
        sb.append("access");
        sb.append('=');
        sb.append(this.access == null ? "<null>" : this.access);
        sb.append(',');
        sb.append("rule");
        sb.append('=');
        sb.append(this.rule == null ? "<null>" : this.rule);
        sb.append(',');
        sb.append("policy");
        sb.append('=');
        sb.append(this.policy == null ? "<null>" : this.policy);
        sb.append(',');
        sb.append("role");
        sb.append('=');
        sb.append(this.role == null ? "<null>" : this.role);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.rule == null ? 0 : this.rule.hashCode());
        result = result * 31 + (this.access == null ? 0 : this.access.hashCode());
        result = result * 31 + (this.role == null ? 0 : this.role.hashCode());
        result = result * 31 + (this.operation == null ? 0 : this.operation.hashCode());
        result = result * 31 + (this.policy == null ? 0 : this.policy.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Permission)) {
            return false;
        }
        Permission rhs = (Permission)other;
        return (this.rule == rhs.rule || this.rule != null && this.rule.equals(rhs.rule)) && (this.access == rhs.access || this.access != null && this.access.equals((Object)rhs.access)) && (this.role == rhs.role || this.role != null && this.role.equals(rhs.role)) && (this.operation == rhs.operation || this.operation != null && this.operation.equals((Object)rhs.operation)) && (this.policy == rhs.policy || this.policy != null && this.policy.equals(rhs.policy));
    }

    public static enum Access {
        DENY("deny"),
        ALLOW("allow"),
        CONDITIONAL_DENY("conditionalDeny"),
        CONDITIONAL_ALLOW("conditionalAllow"),
        NOT_ALLOW("notAllow");

        private final String value;
        private static final Map<String, Access> CONSTANTS;

        private Access(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Access fromValue(String value) {
            Access constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Access>();
            for (Access c : Access.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

