/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum MlFeatureDataType {
    Numerical("numerical"),
    Categorical("categorical");

    private final String value;
    private static final Map<String, MlFeatureDataType> CONSTANTS;

    private MlFeatureDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static MlFeatureDataType fromValue(String value) {
        MlFeatureDataType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, MlFeatureDataType>();
        for (MlFeatureDataType c : MlFeatureDataType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

