/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.type.MlFeatureDataType;
import org.openmetadata.schema.type.MlFeatureSource;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "dataType", "description", "fullyQualifiedName", "featureSources", "featureAlgorithm", "tags"})
public class MlFeature {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) String name;
    @JsonProperty(value="dataType")
    @JsonPropertyDescription(value="This enum defines the type of data stored in a ML Feature.")
    private MlFeatureDataType dataType;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    private @Size(min=1, max=256) String fullyQualifiedName;
    @JsonProperty(value="featureSources")
    @JsonPropertyDescription(value="Columns used to create the ML Feature.")
    @Valid
    private List<MlFeatureSource> featureSources = null;
    @JsonProperty(value="featureAlgorithm")
    @JsonPropertyDescription(value="Description of the algorithm used to compute the feature, e.g., PCA, bucketing...")
    private String featureAlgorithm;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags associated with the feature.")
    @Valid
    private List<TagLabel> tags = null;

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public MlFeature withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="dataType")
    public MlFeatureDataType getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="dataType")
    public void setDataType(MlFeatureDataType dataType) {
        this.dataType = dataType;
    }

    public MlFeature withDataType(MlFeatureDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public MlFeature withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public MlFeature withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @JsonProperty(value="featureSources")
    public List<MlFeatureSource> getFeatureSources() {
        return this.featureSources;
    }

    @JsonProperty(value="featureSources")
    public void setFeatureSources(List<MlFeatureSource> featureSources) {
        this.featureSources = featureSources;
    }

    public MlFeature withFeatureSources(List<MlFeatureSource> featureSources) {
        this.featureSources = featureSources;
        return this;
    }

    @JsonProperty(value="featureAlgorithm")
    public String getFeatureAlgorithm() {
        return this.featureAlgorithm;
    }

    @JsonProperty(value="featureAlgorithm")
    public void setFeatureAlgorithm(String featureAlgorithm) {
        this.featureAlgorithm = featureAlgorithm;
    }

    public MlFeature withFeatureAlgorithm(String featureAlgorithm) {
        this.featureAlgorithm = featureAlgorithm;
        return this;
    }

    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public MlFeature withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MlFeature.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("dataType");
        sb.append('=');
        sb.append(this.dataType == null ? "<null>" : this.dataType);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("featureSources");
        sb.append('=');
        sb.append(this.featureSources == null ? "<null>" : this.featureSources);
        sb.append(',');
        sb.append("featureAlgorithm");
        sb.append('=');
        sb.append(this.featureAlgorithm == null ? "<null>" : this.featureAlgorithm);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.featureSources == null ? 0 : this.featureSources.hashCode());
        result = result * 31 + (this.featureAlgorithm == null ? 0 : this.featureAlgorithm.hashCode());
        result = result * 31 + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MlFeature)) {
            return false;
        }
        MlFeature rhs = (MlFeature)other;
        return (this.featureSources == rhs.featureSources || this.featureSources != null && this.featureSources.equals(rhs.featureSources)) && (this.featureAlgorithm == rhs.featureAlgorithm || this.featureAlgorithm != null && this.featureAlgorithm.equals(rhs.featureAlgorithm)) && (this.dataType == rhs.dataType || this.dataType != null && this.dataType.equals((Object)rhs.dataType)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags));
    }
}

