/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum FeatureSourceDataType {
    INTEGER("integer"),
    NUMBER("number"),
    STRING("string"),
    ARRAY("array"),
    DATE("date"),
    TIMESTAMP("timestamp"),
    OBJECT("object"),
    BOOLEAN("boolean");

    private final String value;
    private static final Map<String, FeatureSourceDataType> CONSTANTS;

    private FeatureSourceDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static FeatureSourceDataType fromValue(String value) {
        FeatureSourceDataType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, FeatureSourceDataType>();
        for (FeatureSourceDataType c : FeatureSourceDataType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

