/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum DataModelType {
    TableauSheet("TableauSheet"),
    SupersetDataModel("SupersetDataModel"),
    MetabaseDataModel("MetabaseDataModel");

    private final String value;
    private static final Map<String, DataModelType> CONSTANTS;

    private DataModelType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static DataModelType fromValue(String value) {
        DataModelType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, DataModelType>();
        for (DataModelType c : DataModelType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

