/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.openmetadata.schema.EnumInterface;

public enum ContainerFileFormat implements EnumInterface
{
    Zip("zip"),
    Gz("gz"),
    Zstd("zstd"),
    Csv("csv"),
    Tsv("tsv"),
    Json("json"),
    Parquet("parquet"),
    Avro("avro");

    private final String value;
    private static final Map<String, ContainerFileFormat> CONSTANTS;

    private ContainerFileFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @Override
    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ContainerFileFormat fromValue(String value) {
        ContainerFileFormat constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ContainerFileFormat>();
        for (ContainerFileFormat c : ContainerFileFormat.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

