/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.type.JoinedWith;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"columnName", "joinedWith"})
public class ColumnJoin {
    @JsonProperty(value="columnName")
    @JsonPropertyDescription(value="Local name (not fully qualified name) of the column. ColumnName is `-` when the column is not named in struct dataType. For example, BigQuery supports struct with unnamed fields.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=128)
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=128) String columnName;
    @JsonProperty(value="joinedWith")
    @JsonPropertyDescription(value="Fully qualified names of the columns that this column is joined with.")
    @Valid
    private List<JoinedWith> joinedWith = new ArrayList<JoinedWith>();

    @JsonProperty(value="columnName")
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty(value="columnName")
    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public ColumnJoin withColumnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    @JsonProperty(value="joinedWith")
    public List<JoinedWith> getJoinedWith() {
        return this.joinedWith;
    }

    @JsonProperty(value="joinedWith")
    public void setJoinedWith(List<JoinedWith> joinedWith) {
        this.joinedWith = joinedWith;
    }

    public ColumnJoin withJoinedWith(List<JoinedWith> joinedWith) {
        this.joinedWith = joinedWith;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ColumnJoin.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("columnName");
        sb.append('=');
        sb.append(this.columnName == null ? "<null>" : this.columnName);
        sb.append(',');
        sb.append("joinedWith");
        sb.append('=');
        sb.append(this.joinedWith == null ? "<null>" : this.joinedWith);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.joinedWith == null ? 0 : this.joinedWith.hashCode());
        result = result * 31 + (this.columnName == null ? 0 : this.columnName.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ColumnJoin)) {
            return false;
        }
        ColumnJoin rhs = (ColumnJoin)other;
        return (this.joinedWith == rhs.joinedWith || this.joinedWith != null && this.joinedWith.equals(rhs.joinedWith)) && (this.columnName == rhs.columnName || this.columnName != null && this.columnName.equals(rhs.columnName));
    }
}

