/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.tests.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.openmetadata.schema.tests.type.TestCaseStatus;
import org.openmetadata.schema.tests.type.TestResultValue;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"timestamp", "testCaseStatus", "result", "sampleData", "testResultValue"})
public class TestCaseResult {
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long timestamp;
    @JsonProperty(value="testCaseStatus")
    @JsonPropertyDescription(value="Status of Test Case run.")
    private TestCaseStatus testCaseStatus;
    @JsonProperty(value="result")
    @JsonPropertyDescription(value="Details of test case results.")
    private String result;
    @JsonProperty(value="sampleData")
    @JsonPropertyDescription(value="sample data to capture rows/columns that didn't match the expressed testcase.")
    private String sampleData;
    @JsonProperty(value="testResultValue")
    @Valid
    private List<TestResultValue> testResultValue = new ArrayList<TestResultValue>();

    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public TestCaseResult withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="testCaseStatus")
    public TestCaseStatus getTestCaseStatus() {
        return this.testCaseStatus;
    }

    @JsonProperty(value="testCaseStatus")
    public void setTestCaseStatus(TestCaseStatus testCaseStatus) {
        this.testCaseStatus = testCaseStatus;
    }

    public TestCaseResult withTestCaseStatus(TestCaseStatus testCaseStatus) {
        this.testCaseStatus = testCaseStatus;
        return this;
    }

    @JsonProperty(value="result")
    public String getResult() {
        return this.result;
    }

    @JsonProperty(value="result")
    public void setResult(String result) {
        this.result = result;
    }

    public TestCaseResult withResult(String result) {
        this.result = result;
        return this;
    }

    @JsonProperty(value="sampleData")
    public String getSampleData() {
        return this.sampleData;
    }

    @JsonProperty(value="sampleData")
    public void setSampleData(String sampleData) {
        this.sampleData = sampleData;
    }

    public TestCaseResult withSampleData(String sampleData) {
        this.sampleData = sampleData;
        return this;
    }

    @JsonProperty(value="testResultValue")
    public List<TestResultValue> getTestResultValue() {
        return this.testResultValue;
    }

    @JsonProperty(value="testResultValue")
    public void setTestResultValue(List<TestResultValue> testResultValue) {
        this.testResultValue = testResultValue;
    }

    public TestCaseResult withTestResultValue(List<TestResultValue> testResultValue) {
        this.testResultValue = testResultValue;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestCaseResult.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("testCaseStatus");
        sb.append('=');
        sb.append(this.testCaseStatus == null ? "<null>" : this.testCaseStatus);
        sb.append(',');
        sb.append("result");
        sb.append('=');
        sb.append(this.result == null ? "<null>" : this.result);
        sb.append(',');
        sb.append("sampleData");
        sb.append('=');
        sb.append(this.sampleData == null ? "<null>" : this.sampleData);
        sb.append(',');
        sb.append("testResultValue");
        sb.append('=');
        sb.append(this.testResultValue == null ? "<null>" : this.testResultValue);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.result == null ? 0 : this.result.hashCode());
        result = result * 31 + (this.testCaseStatus == null ? 0 : this.testCaseStatus.hashCode());
        result = result * 31 + (this.sampleData == null ? 0 : this.sampleData.hashCode());
        result = result * 31 + (this.testResultValue == null ? 0 : this.testResultValue.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TestCaseResult)) {
            return false;
        }
        TestCaseResult rhs = (TestCaseResult)other;
        return (this.result == rhs.result || this.result != null && this.result.equals(rhs.result)) && (this.testCaseStatus == rhs.testCaseStatus || this.testCaseStatus != null && this.testCaseStatus.equals((Object)rhs.testCaseStatus)) && (this.sampleData == rhs.sampleData || this.sampleData != null && this.sampleData.equals(rhs.sampleData)) && (this.testResultValue == rhs.testResultValue || this.testResultValue != null && this.testResultValue.equals(rhs.testResultValue)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }
}

