/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.tests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum TestPlatform {
    OPEN_METADATA("OpenMetadata"),
    GREAT_EXPECTATIONS("GreatExpectations"),
    DBT("DBT"),
    DEEQU("Deequ"),
    SODA("Soda"),
    OTHER("Other");

    private final String value;
    private static final Map<String, TestPlatform> CONSTANTS;

    private TestPlatform(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static TestPlatform fromValue(String value) {
        TestPlatform constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, TestPlatform>();
        for (TestPlatform c : TestPlatform.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

