/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.settings;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum SettingsType {
    AUTHORIZER_CONFIGURATION("authorizerConfiguration"),
    AUTHENTICATION_CONFIGURATION("authenticationConfiguration"),
    JWT_TOKEN_CONFIGURATION("jwtTokenConfiguration"),
    ELASTICSEARCH("elasticsearch"),
    EVENT_HANDLER_CONFIGURATION("eventHandlerConfiguration"),
    AIRFLOW_CONFIGURATION("airflowConfiguration"),
    FERNET_CONFIGURATION("fernetConfiguration"),
    SLACK_EVENT_PUBLISHERS("slackEventPublishers"),
    SECRETS_MANAGER_CONFIGURATION("secretsManagerConfiguration"),
    SANDBOX_MODE_ENABLED("sandboxModeEnabled"),
    SLACK_CHAT("slackChat"),
    TASK_NOTIFICATION_CONFIGURATION("taskNotificationConfiguration"),
    TEST_RESULT_NOTIFICATION_CONFIGURATION("testResultNotificationConfiguration");

    private final String value;
    private static final Map<String, SettingsType> CONSTANTS;

    private SettingsType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static SettingsType fromValue(String value) {
        SettingsType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, SettingsType>();
        for (SettingsType c : SettingsType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

