/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.settings;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.api.CreateEventPublisherJob;
import org.openmetadata.schema.settings.FailureDetails;
import org.openmetadata.schema.settings.Stats;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "startedBy", "publisherType", "runMode", "timestamp", "startTime", "endTime", "status", "failureDetails", "stats", "entities"})
public class EventPublisherJob {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the result")
    @NotNull
    private String name;
    @JsonProperty(value="startedBy")
    @JsonPropertyDescription(value="Job started by")
    private String startedBy;
    @JsonProperty(value="publisherType")
    @JsonPropertyDescription(value="This schema event Publisher Types")
    @NotNull
    private CreateEventPublisherJob.PublisherType publisherType;
    @JsonProperty(value="runMode")
    @JsonPropertyDescription(value="This schema publisher run modes.")
    @NotNull
    private CreateEventPublisherJob.RunMode runMode;
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    @NotNull
    private Long timestamp;
    @JsonProperty(value="startTime")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long startTime;
    @JsonProperty(value="endTime")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long endTime;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="This schema publisher run job status.")
    @NotNull
    private Status status;
    @JsonProperty(value="failureDetails")
    @JsonPropertyDescription(value="Failure details are set only when `status` is not `success`.")
    @Valid
    private FailureDetails failureDetails;
    @JsonProperty(value="stats")
    @Valid
    private Stats stats;
    @JsonProperty(value="entities")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="List of Entities to Reindex")
    @Valid
    private Set<String> entities = new LinkedHashSet<String>();

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public EventPublisherJob withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="startedBy")
    public String getStartedBy() {
        return this.startedBy;
    }

    @JsonProperty(value="startedBy")
    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    public EventPublisherJob withStartedBy(String startedBy) {
        this.startedBy = startedBy;
        return this;
    }

    @JsonProperty(value="publisherType")
    public CreateEventPublisherJob.PublisherType getPublisherType() {
        return this.publisherType;
    }

    @JsonProperty(value="publisherType")
    public void setPublisherType(CreateEventPublisherJob.PublisherType publisherType) {
        this.publisherType = publisherType;
    }

    public EventPublisherJob withPublisherType(CreateEventPublisherJob.PublisherType publisherType) {
        this.publisherType = publisherType;
        return this;
    }

    @JsonProperty(value="runMode")
    public CreateEventPublisherJob.RunMode getRunMode() {
        return this.runMode;
    }

    @JsonProperty(value="runMode")
    public void setRunMode(CreateEventPublisherJob.RunMode runMode) {
        this.runMode = runMode;
    }

    public EventPublisherJob withRunMode(CreateEventPublisherJob.RunMode runMode) {
        this.runMode = runMode;
        return this;
    }

    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public EventPublisherJob withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="startTime")
    public Long getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="startTime")
    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public EventPublisherJob withStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    @JsonProperty(value="endTime")
    public Long getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="endTime")
    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public EventPublisherJob withEndTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    @JsonProperty(value="status")
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(Status status) {
        this.status = status;
    }

    public EventPublisherJob withStatus(Status status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="failureDetails")
    public FailureDetails getFailureDetails() {
        return this.failureDetails;
    }

    @JsonProperty(value="failureDetails")
    public void setFailureDetails(FailureDetails failureDetails) {
        this.failureDetails = failureDetails;
    }

    public EventPublisherJob withFailureDetails(FailureDetails failureDetails) {
        this.failureDetails = failureDetails;
        return this;
    }

    @JsonProperty(value="stats")
    public Stats getStats() {
        return this.stats;
    }

    @JsonProperty(value="stats")
    public void setStats(Stats stats) {
        this.stats = stats;
    }

    public EventPublisherJob withStats(Stats stats) {
        this.stats = stats;
        return this;
    }

    @JsonProperty(value="entities")
    public Set<String> getEntities() {
        return this.entities;
    }

    @JsonProperty(value="entities")
    public void setEntities(Set<String> entities) {
        this.entities = entities;
    }

    public EventPublisherJob withEntities(Set<String> entities) {
        this.entities = entities;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EventPublisherJob.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("startedBy");
        sb.append('=');
        sb.append(this.startedBy == null ? "<null>" : this.startedBy);
        sb.append(',');
        sb.append("publisherType");
        sb.append('=');
        sb.append(this.publisherType == null ? "<null>" : this.publisherType);
        sb.append(',');
        sb.append("runMode");
        sb.append('=');
        sb.append(this.runMode == null ? "<null>" : this.runMode);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("startTime");
        sb.append('=');
        sb.append(this.startTime == null ? "<null>" : this.startTime);
        sb.append(',');
        sb.append("endTime");
        sb.append('=');
        sb.append(this.endTime == null ? "<null>" : this.endTime);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("failureDetails");
        sb.append('=');
        sb.append(this.failureDetails == null ? "<null>" : this.failureDetails);
        sb.append(',');
        sb.append("stats");
        sb.append('=');
        sb.append(this.stats == null ? "<null>" : this.stats);
        sb.append(',');
        sb.append("entities");
        sb.append('=');
        sb.append(this.entities == null ? "<null>" : this.entities);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.publisherType == null ? 0 : this.publisherType.hashCode());
        result = result * 31 + (this.startedBy == null ? 0 : this.startedBy.hashCode());
        result = result * 31 + (this.stats == null ? 0 : this.stats.hashCode());
        result = result * 31 + (this.entities == null ? 0 : this.entities.hashCode());
        result = result * 31 + (this.failureDetails == null ? 0 : this.failureDetails.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.startTime == null ? 0 : this.startTime.hashCode());
        result = result * 31 + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = result * 31 + (this.runMode == null ? 0 : this.runMode.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EventPublisherJob)) {
            return false;
        }
        EventPublisherJob rhs = (EventPublisherJob)other;
        return (this.publisherType == rhs.publisherType || this.publisherType != null && this.publisherType.equals((Object)rhs.publisherType)) && (this.startedBy == rhs.startedBy || this.startedBy != null && this.startedBy.equals(rhs.startedBy)) && (this.stats == rhs.stats || this.stats != null && this.stats.equals(rhs.stats)) && (this.entities == rhs.entities || this.entities != null && this.entities.equals(rhs.entities)) && (this.failureDetails == rhs.failureDetails || this.failureDetails != null && this.failureDetails.equals(rhs.failureDetails)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.startTime == rhs.startTime || this.startTime != null && this.startTime.equals(rhs.startTime)) && (this.endTime == rhs.endTime || this.endTime != null && this.endTime.equals(rhs.endTime)) && (this.runMode == rhs.runMode || this.runMode != null && this.runMode.equals((Object)rhs.runMode)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }

    public static enum Status {
        STARTING("STARTING"),
        ACTIVE("ACTIVE"),
        RETRY("RETRY"),
        ACTIVE_WITH_ERROR("ACTIVE_WITH_ERROR"),
        IDLE("IDLE"),
        COMPLETED("COMPLETED");

        private final String value;
        private static final Map<String, Status> CONSTANTS;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Status fromValue(String value) {
            Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Status>();
            for (Status c : Status.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

