/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.pipeline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.security.credentials.AWSCredentials;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "awsConfig", "supportsMetadataExtraction"})
public class GluePipelineConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private GlueType type = GlueType.fromValue("GluePipeline");
    @JsonProperty(value="awsConfig")
    @JsonPropertyDescription(value="AWS credentials configs.")
    @Valid
    @NotNull
    private AWSCredentials awsConfig;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public GlueType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(GlueType type) {
        this.type = type;
    }

    public GluePipelineConnection withType(GlueType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="awsConfig")
    public AWSCredentials getAwsConfig() {
        return this.awsConfig;
    }

    @JsonProperty(value="awsConfig")
    public void setAwsConfig(AWSCredentials awsConfig) {
        this.awsConfig = awsConfig;
    }

    public GluePipelineConnection withAwsConfig(AWSCredentials awsConfig) {
        this.awsConfig = awsConfig;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public GluePipelineConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GluePipelineConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("awsConfig");
        sb.append('=');
        sb.append(this.awsConfig == null ? "<null>" : this.awsConfig);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.awsConfig == null ? 0 : this.awsConfig.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GluePipelineConnection)) {
            return false;
        }
        GluePipelineConnection rhs = (GluePipelineConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.awsConfig == rhs.awsConfig || this.awsConfig != null && this.awsConfig.equals(rhs.awsConfig));
    }

    public static enum GlueType {
        GLUE_PIPELINE("GluePipeline");

        private final String value;
        private static final Map<String, GlueType> CONSTANTS;

        private GlueType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static GlueType fromValue(String value) {
            GlueType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, GlueType>();
            for (GlueType c : GlueType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

