/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.pipeline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "hostPort", "token", "httpPath", "connectionArguments", "supportsMetadataExtraction"})
public class DatabricksPipelineConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private DatabricksType type = DatabricksType.fromValue("DatabricksPipeline");
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Host and port of the Databricks service.")
    @NotNull
    private String hostPort;
    @JsonProperty(value="token")
    @JsonPropertyDescription(value="Generated Token to connect to Databricks.")
    @PasswordField
    @NotNull
    private String token;
    @JsonProperty(value="httpPath")
    @JsonPropertyDescription(value="Databricks compute resources URL.")
    private String httpPath;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public DatabricksType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(DatabricksType type) {
        this.type = type;
    }

    public DatabricksPipelineConnection withType(DatabricksType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="hostPort")
    public String getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public DatabricksPipelineConnection withHostPort(String hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="token")
    @PasswordField
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @PasswordField
    public void setToken(String token) {
        this.token = token;
    }

    public DatabricksPipelineConnection withToken(String token) {
        this.token = token;
        return this;
    }

    @JsonProperty(value="httpPath")
    public String getHttpPath() {
        return this.httpPath;
    }

    @JsonProperty(value="httpPath")
    public void setHttpPath(String httpPath) {
        this.httpPath = httpPath;
    }

    public DatabricksPipelineConnection withHttpPath(String httpPath) {
        this.httpPath = httpPath;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public DatabricksPipelineConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public DatabricksPipelineConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DatabricksPipelineConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("token");
        sb.append('=');
        sb.append(this.token == null ? "<null>" : this.token);
        sb.append(',');
        sb.append("httpPath");
        sb.append('=');
        sb.append(this.httpPath == null ? "<null>" : this.httpPath);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.httpPath == null ? 0 : this.httpPath.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.token == null ? 0 : this.token.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DatabricksPipelineConnection)) {
            return false;
        }
        DatabricksPipelineConnection rhs = (DatabricksPipelineConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.httpPath == rhs.httpPath || this.httpPath != null && this.httpPath.equals(rhs.httpPath)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.token == rhs.token || this.token != null && this.token.equals(rhs.token)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments));
    }

    public static enum DatabricksType {
        DATABRICKS_PIPELINE("DatabricksPipeline");

        private final String value;
        private static final Map<String, DatabricksType> CONSTANTS;

        private DatabricksType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DatabricksType fromValue(String value) {
            DatabricksType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DatabricksType>();
            for (DatabricksType c : DatabricksType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

