/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "includeTopics", "includeTables", "includeDashboards", "includePipelines", "includeMlModels", "includeUsers", "includeTeams", "includeGlossaryTerms", "includePolicy", "includeMessagingServices", "includeDatabaseServices", "includePipelineServices", "includeTags", "limitRecords", "supportsMetadataExtraction"})
public class MetadataESConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Metadata to Elastic Search type")
    private MetadataESType type = MetadataESType.fromValue("MetadataES");
    @JsonProperty(value="includeTopics")
    @JsonPropertyDescription(value="Include Topics for Indexing")
    private Boolean includeTopics = true;
    @JsonProperty(value="includeTables")
    @JsonPropertyDescription(value="Include Tables for Indexing")
    private Boolean includeTables = true;
    @JsonProperty(value="includeDashboards")
    @JsonPropertyDescription(value="Include Dashboards for Indexing")
    private Boolean includeDashboards = true;
    @JsonProperty(value="includePipelines")
    @JsonPropertyDescription(value="Include Pipelines for Indexing")
    private Boolean includePipelines = true;
    @JsonProperty(value="includeMlModels")
    @JsonPropertyDescription(value="Include MlModels for Indexing")
    private Boolean includeMlModels = true;
    @JsonProperty(value="includeUsers")
    @JsonPropertyDescription(value="Include Users for Indexing")
    private Boolean includeUsers = true;
    @JsonProperty(value="includeTeams")
    @JsonPropertyDescription(value="Include Teams for Indexing")
    private Boolean includeTeams = true;
    @JsonProperty(value="includeGlossaryTerms")
    @JsonPropertyDescription(value="Include Glossary Terms for Indexing")
    private Boolean includeGlossaryTerms = true;
    @JsonProperty(value="includePolicy")
    @JsonPropertyDescription(value="Include Tags for Policy")
    private Boolean includePolicy = true;
    @JsonProperty(value="includeMessagingServices")
    @JsonPropertyDescription(value="Include Messaging Services for Indexing")
    private Boolean includeMessagingServices = true;
    @JsonProperty(value="includeDatabaseServices")
    @JsonPropertyDescription(value="Include Database Services for Indexing")
    private Boolean includeDatabaseServices = true;
    @JsonProperty(value="includePipelineServices")
    @JsonPropertyDescription(value="Include Pipeline Services for Indexing")
    private Boolean includePipelineServices = true;
    @JsonProperty(value="includeTags")
    @JsonPropertyDescription(value="Include Tags for Indexing")
    private Boolean includeTags = true;
    @JsonProperty(value="limitRecords")
    @JsonPropertyDescription(value="Limit the number of records for Indexing.")
    private Integer limitRecords = 1000;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public MetadataESType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(MetadataESType type) {
        this.type = type;
    }

    public MetadataESConnection withType(MetadataESType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="includeTopics")
    public Boolean getIncludeTopics() {
        return this.includeTopics;
    }

    @JsonProperty(value="includeTopics")
    public void setIncludeTopics(Boolean includeTopics) {
        this.includeTopics = includeTopics;
    }

    public MetadataESConnection withIncludeTopics(Boolean includeTopics) {
        this.includeTopics = includeTopics;
        return this;
    }

    @JsonProperty(value="includeTables")
    public Boolean getIncludeTables() {
        return this.includeTables;
    }

    @JsonProperty(value="includeTables")
    public void setIncludeTables(Boolean includeTables) {
        this.includeTables = includeTables;
    }

    public MetadataESConnection withIncludeTables(Boolean includeTables) {
        this.includeTables = includeTables;
        return this;
    }

    @JsonProperty(value="includeDashboards")
    public Boolean getIncludeDashboards() {
        return this.includeDashboards;
    }

    @JsonProperty(value="includeDashboards")
    public void setIncludeDashboards(Boolean includeDashboards) {
        this.includeDashboards = includeDashboards;
    }

    public MetadataESConnection withIncludeDashboards(Boolean includeDashboards) {
        this.includeDashboards = includeDashboards;
        return this;
    }

    @JsonProperty(value="includePipelines")
    public Boolean getIncludePipelines() {
        return this.includePipelines;
    }

    @JsonProperty(value="includePipelines")
    public void setIncludePipelines(Boolean includePipelines) {
        this.includePipelines = includePipelines;
    }

    public MetadataESConnection withIncludePipelines(Boolean includePipelines) {
        this.includePipelines = includePipelines;
        return this;
    }

    @JsonProperty(value="includeMlModels")
    public Boolean getIncludeMlModels() {
        return this.includeMlModels;
    }

    @JsonProperty(value="includeMlModels")
    public void setIncludeMlModels(Boolean includeMlModels) {
        this.includeMlModels = includeMlModels;
    }

    public MetadataESConnection withIncludeMlModels(Boolean includeMlModels) {
        this.includeMlModels = includeMlModels;
        return this;
    }

    @JsonProperty(value="includeUsers")
    public Boolean getIncludeUsers() {
        return this.includeUsers;
    }

    @JsonProperty(value="includeUsers")
    public void setIncludeUsers(Boolean includeUsers) {
        this.includeUsers = includeUsers;
    }

    public MetadataESConnection withIncludeUsers(Boolean includeUsers) {
        this.includeUsers = includeUsers;
        return this;
    }

    @JsonProperty(value="includeTeams")
    public Boolean getIncludeTeams() {
        return this.includeTeams;
    }

    @JsonProperty(value="includeTeams")
    public void setIncludeTeams(Boolean includeTeams) {
        this.includeTeams = includeTeams;
    }

    public MetadataESConnection withIncludeTeams(Boolean includeTeams) {
        this.includeTeams = includeTeams;
        return this;
    }

    @JsonProperty(value="includeGlossaryTerms")
    public Boolean getIncludeGlossaryTerms() {
        return this.includeGlossaryTerms;
    }

    @JsonProperty(value="includeGlossaryTerms")
    public void setIncludeGlossaryTerms(Boolean includeGlossaryTerms) {
        this.includeGlossaryTerms = includeGlossaryTerms;
    }

    public MetadataESConnection withIncludeGlossaryTerms(Boolean includeGlossaryTerms) {
        this.includeGlossaryTerms = includeGlossaryTerms;
        return this;
    }

    @JsonProperty(value="includePolicy")
    public Boolean getIncludePolicy() {
        return this.includePolicy;
    }

    @JsonProperty(value="includePolicy")
    public void setIncludePolicy(Boolean includePolicy) {
        this.includePolicy = includePolicy;
    }

    public MetadataESConnection withIncludePolicy(Boolean includePolicy) {
        this.includePolicy = includePolicy;
        return this;
    }

    @JsonProperty(value="includeMessagingServices")
    public Boolean getIncludeMessagingServices() {
        return this.includeMessagingServices;
    }

    @JsonProperty(value="includeMessagingServices")
    public void setIncludeMessagingServices(Boolean includeMessagingServices) {
        this.includeMessagingServices = includeMessagingServices;
    }

    public MetadataESConnection withIncludeMessagingServices(Boolean includeMessagingServices) {
        this.includeMessagingServices = includeMessagingServices;
        return this;
    }

    @JsonProperty(value="includeDatabaseServices")
    public Boolean getIncludeDatabaseServices() {
        return this.includeDatabaseServices;
    }

    @JsonProperty(value="includeDatabaseServices")
    public void setIncludeDatabaseServices(Boolean includeDatabaseServices) {
        this.includeDatabaseServices = includeDatabaseServices;
    }

    public MetadataESConnection withIncludeDatabaseServices(Boolean includeDatabaseServices) {
        this.includeDatabaseServices = includeDatabaseServices;
        return this;
    }

    @JsonProperty(value="includePipelineServices")
    public Boolean getIncludePipelineServices() {
        return this.includePipelineServices;
    }

    @JsonProperty(value="includePipelineServices")
    public void setIncludePipelineServices(Boolean includePipelineServices) {
        this.includePipelineServices = includePipelineServices;
    }

    public MetadataESConnection withIncludePipelineServices(Boolean includePipelineServices) {
        this.includePipelineServices = includePipelineServices;
        return this;
    }

    @JsonProperty(value="includeTags")
    public Boolean getIncludeTags() {
        return this.includeTags;
    }

    @JsonProperty(value="includeTags")
    public void setIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
    }

    public MetadataESConnection withIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    @JsonProperty(value="limitRecords")
    public Integer getLimitRecords() {
        return this.limitRecords;
    }

    @JsonProperty(value="limitRecords")
    public void setLimitRecords(Integer limitRecords) {
        this.limitRecords = limitRecords;
    }

    public MetadataESConnection withLimitRecords(Integer limitRecords) {
        this.limitRecords = limitRecords;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public MetadataESConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MetadataESConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("includeTopics");
        sb.append('=');
        sb.append(this.includeTopics == null ? "<null>" : this.includeTopics);
        sb.append(',');
        sb.append("includeTables");
        sb.append('=');
        sb.append(this.includeTables == null ? "<null>" : this.includeTables);
        sb.append(',');
        sb.append("includeDashboards");
        sb.append('=');
        sb.append(this.includeDashboards == null ? "<null>" : this.includeDashboards);
        sb.append(',');
        sb.append("includePipelines");
        sb.append('=');
        sb.append(this.includePipelines == null ? "<null>" : this.includePipelines);
        sb.append(',');
        sb.append("includeMlModels");
        sb.append('=');
        sb.append(this.includeMlModels == null ? "<null>" : this.includeMlModels);
        sb.append(',');
        sb.append("includeUsers");
        sb.append('=');
        sb.append(this.includeUsers == null ? "<null>" : this.includeUsers);
        sb.append(',');
        sb.append("includeTeams");
        sb.append('=');
        sb.append(this.includeTeams == null ? "<null>" : this.includeTeams);
        sb.append(',');
        sb.append("includeGlossaryTerms");
        sb.append('=');
        sb.append(this.includeGlossaryTerms == null ? "<null>" : this.includeGlossaryTerms);
        sb.append(',');
        sb.append("includePolicy");
        sb.append('=');
        sb.append(this.includePolicy == null ? "<null>" : this.includePolicy);
        sb.append(',');
        sb.append("includeMessagingServices");
        sb.append('=');
        sb.append(this.includeMessagingServices == null ? "<null>" : this.includeMessagingServices);
        sb.append(',');
        sb.append("includeDatabaseServices");
        sb.append('=');
        sb.append(this.includeDatabaseServices == null ? "<null>" : this.includeDatabaseServices);
        sb.append(',');
        sb.append("includePipelineServices");
        sb.append('=');
        sb.append(this.includePipelineServices == null ? "<null>" : this.includePipelineServices);
        sb.append(',');
        sb.append("includeTags");
        sb.append('=');
        sb.append(this.includeTags == null ? "<null>" : this.includeTags);
        sb.append(',');
        sb.append("limitRecords");
        sb.append('=');
        sb.append(this.limitRecords == null ? "<null>" : this.limitRecords);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.includeTables == null ? 0 : this.includeTables.hashCode());
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.includeTeams == null ? 0 : this.includeTeams.hashCode());
        result = result * 31 + (this.includeTags == null ? 0 : this.includeTags.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.includePipelineServices == null ? 0 : this.includePipelineServices.hashCode());
        result = result * 31 + (this.includeDashboards == null ? 0 : this.includeDashboards.hashCode());
        result = result * 31 + (this.includeTopics == null ? 0 : this.includeTopics.hashCode());
        result = result * 31 + (this.includePipelines == null ? 0 : this.includePipelines.hashCode());
        result = result * 31 + (this.includeMessagingServices == null ? 0 : this.includeMessagingServices.hashCode());
        result = result * 31 + (this.includePolicy == null ? 0 : this.includePolicy.hashCode());
        result = result * 31 + (this.includeDatabaseServices == null ? 0 : this.includeDatabaseServices.hashCode());
        result = result * 31 + (this.includeGlossaryTerms == null ? 0 : this.includeGlossaryTerms.hashCode());
        result = result * 31 + (this.limitRecords == null ? 0 : this.limitRecords.hashCode());
        result = result * 31 + (this.includeMlModels == null ? 0 : this.includeMlModels.hashCode());
        result = result * 31 + (this.includeUsers == null ? 0 : this.includeUsers.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MetadataESConnection)) {
            return false;
        }
        MetadataESConnection rhs = (MetadataESConnection)other;
        return (this.includeTables == rhs.includeTables || this.includeTables != null && this.includeTables.equals(rhs.includeTables)) && (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.includeTeams == rhs.includeTeams || this.includeTeams != null && this.includeTeams.equals(rhs.includeTeams)) && (this.includeTags == rhs.includeTags || this.includeTags != null && this.includeTags.equals(rhs.includeTags)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.includePipelineServices == rhs.includePipelineServices || this.includePipelineServices != null && this.includePipelineServices.equals(rhs.includePipelineServices)) && (this.includeDashboards == rhs.includeDashboards || this.includeDashboards != null && this.includeDashboards.equals(rhs.includeDashboards)) && (this.includeTopics == rhs.includeTopics || this.includeTopics != null && this.includeTopics.equals(rhs.includeTopics)) && (this.includePipelines == rhs.includePipelines || this.includePipelines != null && this.includePipelines.equals(rhs.includePipelines)) && (this.includeMessagingServices == rhs.includeMessagingServices || this.includeMessagingServices != null && this.includeMessagingServices.equals(rhs.includeMessagingServices)) && (this.includePolicy == rhs.includePolicy || this.includePolicy != null && this.includePolicy.equals(rhs.includePolicy)) && (this.includeDatabaseServices == rhs.includeDatabaseServices || this.includeDatabaseServices != null && this.includeDatabaseServices.equals(rhs.includeDatabaseServices)) && (this.includeGlossaryTerms == rhs.includeGlossaryTerms || this.includeGlossaryTerms != null && this.includeGlossaryTerms.equals(rhs.includeGlossaryTerms)) && (this.limitRecords == rhs.limitRecords || this.limitRecords != null && this.limitRecords.equals(rhs.limitRecords)) && (this.includeMlModels == rhs.includeMlModels || this.includeMlModels != null && this.includeMlModels.equals(rhs.includeMlModels)) && (this.includeUsers == rhs.includeUsers || this.includeUsers != null && this.includeUsers.equals(rhs.includeUsers));
    }

    public static enum MetadataESType {
        METADATA_ES("MetadataES");

        private final String value;
        private static final Map<String, MetadataESType> CONSTANTS;

        private MetadataESType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataESType fromValue(String value) {
            MetadataESType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, MetadataESType>();
            for (MetadataESType c : MetadataESType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

