/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "sourcePythonClass", "connectionOptions"})
public class CustomDatabaseConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Custom database service type")
    @NotNull
    private CustomDatabaseType type = CustomDatabaseType.fromValue("CustomDatabase");
    @JsonProperty(value="sourcePythonClass")
    @JsonPropertyDescription(value="Source Python Class Name to instantiated by the ingestion workflow")
    @NotNull
    private String sourcePythonClass;
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;

    @JsonProperty(value="type")
    public CustomDatabaseType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(CustomDatabaseType type) {
        this.type = type;
    }

    public CustomDatabaseConnection withType(CustomDatabaseType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="sourcePythonClass")
    public String getSourcePythonClass() {
        return this.sourcePythonClass;
    }

    @JsonProperty(value="sourcePythonClass")
    public void setSourcePythonClass(String sourcePythonClass) {
        this.sourcePythonClass = sourcePythonClass;
    }

    public CustomDatabaseConnection withSourcePythonClass(String sourcePythonClass) {
        this.sourcePythonClass = sourcePythonClass;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public CustomDatabaseConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CustomDatabaseConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("sourcePythonClass");
        sb.append('=');
        sb.append(this.sourcePythonClass == null ? "<null>" : this.sourcePythonClass);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.sourcePythonClass == null ? 0 : this.sourcePythonClass.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CustomDatabaseConnection)) {
            return false;
        }
        CustomDatabaseConnection rhs = (CustomDatabaseConnection)other;
        return (this.sourcePythonClass == rhs.sourcePythonClass || this.sourcePythonClass != null && this.sourcePythonClass.equals(rhs.sourcePythonClass)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions));
    }

    public static enum CustomDatabaseType {
        CUSTOM_DATABASE("CustomDatabase");

        private final String value;
        private static final Map<String, CustomDatabaseType> CONSTANTS;

        private CustomDatabaseType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CustomDatabaseType fromValue(String value) {
            CustomDatabaseType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CustomDatabaseType>();
            for (CustomDatabaseType c : CustomDatabaseType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

