/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "scheme", "username", "password", "hostPort", "databaseName", "databaseSchema", "duration", "secure", "keyfile", "connectionOptions", "connectionArguments", "supportsMetadataExtraction", "supportsUsageExtraction", "supportsLineageExtraction", "supportsDBTExtraction", "supportsProfiler", "supportsQueryComment"})
public class ClickhouseConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private ClickhouseType type = ClickhouseType.fromValue("Clickhouse");
    @JsonProperty(value="scheme")
    @JsonPropertyDescription(value="SQLAlchemy driver scheme options.")
    private ClickhouseScheme scheme = ClickhouseScheme.fromValue("clickhouse+http");
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Username to connect to Clickhouse. This user should have privileges to read all the metadata in Clickhouse.")
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Password to connect to Clickhouse.")
    @PasswordField
    private String password;
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Host and port of the Clickhouse service.")
    @NotNull
    private String hostPort;
    @JsonProperty(value="databaseName")
    @JsonPropertyDescription(value="Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.")
    private String databaseName;
    @JsonProperty(value="databaseSchema")
    @JsonPropertyDescription(value="databaseSchema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single databaseSchema. When left blank, OpenMetadata Ingestion attempts to scan all the databaseSchema.")
    private String databaseSchema;
    @JsonProperty(value="duration")
    @JsonPropertyDescription(value="Clickhouse SQL connection duration.")
    private Integer duration;
    @JsonProperty(value="secure")
    @JsonPropertyDescription(value="Establish secure connection with clickhouse")
    private Boolean secure;
    @JsonProperty(value="keyfile")
    @JsonPropertyDescription(value="Path to key file for establishing secure connection")
    private Boolean keyfile;
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;
    @JsonProperty(value="supportsUsageExtraction")
    @JsonPropertyDescription(value="Supports Usage Extraction.")
    private Boolean supportsUsageExtraction = true;
    @JsonProperty(value="supportsLineageExtraction")
    @JsonPropertyDescription(value="Supports Lineage Extraction.")
    private Boolean supportsLineageExtraction = true;
    @JsonProperty(value="supportsDBTExtraction")
    @JsonPropertyDescription(value="Supports DBT Extraction.")
    private Boolean supportsDBTExtraction = true;
    @JsonProperty(value="supportsProfiler")
    @JsonPropertyDescription(value="Supports Profiler")
    private Boolean supportsProfiler = true;
    @JsonProperty(value="supportsQueryComment")
    @JsonPropertyDescription(value="For Database Services using SQLAlchemy, True to enable running a comment for all queries run from OpenMetadata.")
    private Boolean supportsQueryComment = true;

    @JsonProperty(value="type")
    public ClickhouseType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(ClickhouseType type) {
        this.type = type;
    }

    public ClickhouseConnection withType(ClickhouseType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="scheme")
    public ClickhouseScheme getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    public void setScheme(ClickhouseScheme scheme) {
        this.scheme = scheme;
    }

    public ClickhouseConnection withScheme(ClickhouseScheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public ClickhouseConnection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    @PasswordField
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @PasswordField
    public void setPassword(String password) {
        this.password = password;
    }

    public ClickhouseConnection withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="hostPort")
    public String getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public ClickhouseConnection withHostPort(String hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="databaseName")
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty(value="databaseName")
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public ClickhouseConnection withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @JsonProperty(value="databaseSchema")
    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    @JsonProperty(value="databaseSchema")
    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public ClickhouseConnection withDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
        return this;
    }

    @JsonProperty(value="duration")
    public Integer getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public ClickhouseConnection withDuration(Integer duration) {
        this.duration = duration;
        return this;
    }

    @JsonProperty(value="secure")
    public Boolean getSecure() {
        return this.secure;
    }

    @JsonProperty(value="secure")
    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public ClickhouseConnection withSecure(Boolean secure) {
        this.secure = secure;
        return this;
    }

    @JsonProperty(value="keyfile")
    public Boolean getKeyfile() {
        return this.keyfile;
    }

    @JsonProperty(value="keyfile")
    public void setKeyfile(Boolean keyfile) {
        this.keyfile = keyfile;
    }

    public ClickhouseConnection withKeyfile(Boolean keyfile) {
        this.keyfile = keyfile;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public ClickhouseConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public ClickhouseConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public ClickhouseConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    @JsonProperty(value="supportsUsageExtraction")
    public Boolean getSupportsUsageExtraction() {
        return this.supportsUsageExtraction;
    }

    @JsonProperty(value="supportsUsageExtraction")
    public void setSupportsUsageExtraction(Boolean supportsUsageExtraction) {
        this.supportsUsageExtraction = supportsUsageExtraction;
    }

    public ClickhouseConnection withSupportsUsageExtraction(Boolean supportsUsageExtraction) {
        this.supportsUsageExtraction = supportsUsageExtraction;
        return this;
    }

    @JsonProperty(value="supportsLineageExtraction")
    public Boolean getSupportsLineageExtraction() {
        return this.supportsLineageExtraction;
    }

    @JsonProperty(value="supportsLineageExtraction")
    public void setSupportsLineageExtraction(Boolean supportsLineageExtraction) {
        this.supportsLineageExtraction = supportsLineageExtraction;
    }

    public ClickhouseConnection withSupportsLineageExtraction(Boolean supportsLineageExtraction) {
        this.supportsLineageExtraction = supportsLineageExtraction;
        return this;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public Boolean getSupportsDBTExtraction() {
        return this.supportsDBTExtraction;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public void setSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
    }

    public ClickhouseConnection withSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
        return this;
    }

    @JsonProperty(value="supportsProfiler")
    public Boolean getSupportsProfiler() {
        return this.supportsProfiler;
    }

    @JsonProperty(value="supportsProfiler")
    public void setSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
    }

    public ClickhouseConnection withSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
        return this;
    }

    @JsonProperty(value="supportsQueryComment")
    public Boolean getSupportsQueryComment() {
        return this.supportsQueryComment;
    }

    @JsonProperty(value="supportsQueryComment")
    public void setSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
    }

    public ClickhouseConnection withSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ClickhouseConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("scheme");
        sb.append('=');
        sb.append(this.scheme == null ? "<null>" : this.scheme);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("databaseName");
        sb.append('=');
        sb.append(this.databaseName == null ? "<null>" : this.databaseName);
        sb.append(',');
        sb.append("databaseSchema");
        sb.append('=');
        sb.append(this.databaseSchema == null ? "<null>" : this.databaseSchema);
        sb.append(',');
        sb.append("duration");
        sb.append('=');
        sb.append(this.duration == null ? "<null>" : this.duration);
        sb.append(',');
        sb.append("secure");
        sb.append('=');
        sb.append(this.secure == null ? "<null>" : this.secure);
        sb.append(',');
        sb.append("keyfile");
        sb.append('=');
        sb.append(this.keyfile == null ? "<null>" : this.keyfile);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        sb.append("supportsUsageExtraction");
        sb.append('=');
        sb.append(this.supportsUsageExtraction == null ? "<null>" : this.supportsUsageExtraction);
        sb.append(',');
        sb.append("supportsLineageExtraction");
        sb.append('=');
        sb.append(this.supportsLineageExtraction == null ? "<null>" : this.supportsLineageExtraction);
        sb.append(',');
        sb.append("supportsDBTExtraction");
        sb.append('=');
        sb.append(this.supportsDBTExtraction == null ? "<null>" : this.supportsDBTExtraction);
        sb.append(',');
        sb.append("supportsProfiler");
        sb.append('=');
        sb.append(this.supportsProfiler == null ? "<null>" : this.supportsProfiler);
        sb.append(',');
        sb.append("supportsQueryComment");
        sb.append('=');
        sb.append(this.supportsQueryComment == null ? "<null>" : this.supportsQueryComment);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.databaseSchema == null ? 0 : this.databaseSchema.hashCode());
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = result * 31 + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        result = result * 31 + (this.supportsProfiler == null ? 0 : this.supportsProfiler.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.secure == null ? 0 : this.secure.hashCode());
        result = result * 31 + (this.supportsUsageExtraction == null ? 0 : this.supportsUsageExtraction.hashCode());
        result = result * 31 + (this.supportsDBTExtraction == null ? 0 : this.supportsDBTExtraction.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        result = result * 31 + (this.duration == null ? 0 : this.duration.hashCode());
        result = result * 31 + (this.supportsLineageExtraction == null ? 0 : this.supportsLineageExtraction.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        result = result * 31 + (this.keyfile == null ? 0 : this.keyfile.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.supportsQueryComment == null ? 0 : this.supportsQueryComment.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ClickhouseConnection)) {
            return false;
        }
        ClickhouseConnection rhs = (ClickhouseConnection)other;
        return (this.databaseSchema == rhs.databaseSchema || this.databaseSchema != null && this.databaseSchema.equals(rhs.databaseSchema)) && (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.scheme == rhs.scheme || this.scheme != null && this.scheme.equals((Object)rhs.scheme)) && (this.databaseName == rhs.databaseName || this.databaseName != null && this.databaseName.equals(rhs.databaseName)) && (this.supportsProfiler == rhs.supportsProfiler || this.supportsProfiler != null && this.supportsProfiler.equals(rhs.supportsProfiler)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.secure == rhs.secure || this.secure != null && this.secure.equals(rhs.secure)) && (this.supportsUsageExtraction == rhs.supportsUsageExtraction || this.supportsUsageExtraction != null && this.supportsUsageExtraction.equals(rhs.supportsUsageExtraction)) && (this.supportsDBTExtraction == rhs.supportsDBTExtraction || this.supportsDBTExtraction != null && this.supportsDBTExtraction.equals(rhs.supportsDBTExtraction)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments)) && (this.duration == rhs.duration || this.duration != null && this.duration.equals(rhs.duration)) && (this.supportsLineageExtraction == rhs.supportsLineageExtraction || this.supportsLineageExtraction != null && this.supportsLineageExtraction.equals(rhs.supportsLineageExtraction)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions)) && (this.keyfile == rhs.keyfile || this.keyfile != null && this.keyfile.equals(rhs.keyfile)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.supportsQueryComment == rhs.supportsQueryComment || this.supportsQueryComment != null && this.supportsQueryComment.equals(rhs.supportsQueryComment)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum ClickhouseType {
        CLICKHOUSE("Clickhouse");

        private final String value;
        private static final Map<String, ClickhouseType> CONSTANTS;

        private ClickhouseType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ClickhouseType fromValue(String value) {
            ClickhouseType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ClickhouseType>();
            for (ClickhouseType c : ClickhouseType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ClickhouseScheme {
        CLICKHOUSE_HTTP("clickhouse+http"),
        CLICKHOUSE_NATIVE("clickhouse+native");

        private final String value;
        private static final Map<String, ClickhouseScheme> CONSTANTS;

        private ClickhouseScheme(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ClickhouseScheme fromValue(String value) {
            ClickhouseScheme constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ClickhouseScheme>();
            for (ClickhouseScheme c : ClickhouseScheme.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

