/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.dashboard;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.schema.services.connections.dashboard.ConnectionOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "hostPort", "connection", "connectionOptions", "supportsMetadataExtraction"})
public class SupersetConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Superset service type")
    private SupersetType type = SupersetType.fromValue("Superset");
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="URL for the superset instance.")
    @ExposedField
    @NotNull
    private URI hostPort = URI.create("http://localhost:8088");
    @JsonProperty(value="connection")
    @JsonPropertyDescription(value="Choose between API or database connection fetch metadata from superset.")
    @NotNull
    private Object connection;
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public SupersetType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(SupersetType type) {
        this.type = type;
    }

    public SupersetConnection withType(SupersetType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public SupersetConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="connection")
    public Object getConnection() {
        return this.connection;
    }

    @JsonProperty(value="connection")
    public void setConnection(Object connection) {
        this.connection = connection;
    }

    public SupersetConnection withConnection(Object connection) {
        this.connection = connection;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public SupersetConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public SupersetConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SupersetConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("connection");
        sb.append('=');
        sb.append(this.connection == null ? "<null>" : this.connection);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.connection == null ? 0 : this.connection.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SupersetConnection)) {
            return false;
        }
        SupersetConnection rhs = (SupersetConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.connection == rhs.connection || this.connection != null && this.connection.equals(rhs.connection)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions));
    }

    public static enum SupersetType {
        SUPERSET("Superset");

        private final String value;
        private static final Map<String, SupersetType> CONSTANTS;

        private SupersetType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SupersetType fromValue(String value) {
            SupersetType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SupersetType>();
            for (SupersetType c : SupersetType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

