/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.dashboard;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "username", "hostPort", "apiKey", "redashVersion", "supportsMetadataExtraction"})
public class RedashConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Redash service type")
    private RedashType type = RedashType.fromValue("Redash");
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Username for Redash")
    @NotNull
    private String username;
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="URL for the Redash instance")
    @ExposedField
    @NotNull
    private URI hostPort = URI.create("http://localhost:5000");
    @JsonProperty(value="apiKey")
    @JsonPropertyDescription(value="API key of the redash instance to access.")
    @PasswordField
    @NotNull
    private String apiKey;
    @JsonProperty(value="redashVersion")
    @JsonPropertyDescription(value="Version of the Redash instance")
    private String redashVersion = "10.0.0";
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public RedashType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(RedashType type) {
        this.type = type;
    }

    public RedashConnection withType(RedashType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public RedashConnection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public RedashConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="apiKey")
    @PasswordField
    public String getApiKey() {
        return this.apiKey;
    }

    @JsonProperty(value="apiKey")
    @PasswordField
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public RedashConnection withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @JsonProperty(value="redashVersion")
    public String getRedashVersion() {
        return this.redashVersion;
    }

    @JsonProperty(value="redashVersion")
    public void setRedashVersion(String redashVersion) {
        this.redashVersion = redashVersion;
    }

    public RedashConnection withRedashVersion(String redashVersion) {
        this.redashVersion = redashVersion;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public RedashConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RedashConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("apiKey");
        sb.append('=');
        sb.append(this.apiKey == null ? "<null>" : this.apiKey);
        sb.append(',');
        sb.append("redashVersion");
        sb.append('=');
        sb.append(this.redashVersion == null ? "<null>" : this.redashVersion);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.apiKey == null ? 0 : this.apiKey.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.redashVersion == null ? 0 : this.redashVersion.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RedashConnection)) {
            return false;
        }
        RedashConnection rhs = (RedashConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.apiKey == rhs.apiKey || this.apiKey != null && this.apiKey.equals(rhs.apiKey)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.redashVersion == rhs.redashVersion || this.redashVersion != null && this.redashVersion.equals(rhs.redashVersion)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum RedashType {
        REDASH("Redash");

        private final String value;
        private static final Map<String, RedashType> CONSTANTS;

        private RedashType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static RedashType fromValue(String value) {
            RedashType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, RedashType>();
            for (RedashType c : RedashType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

