/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.dashboard;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.security.credentials.AWSCredentials;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "awsConfig", "awsAccountId", "identityType", "namespace", "supportsMetadataExtraction"})
public class QuickSightConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="QuickSight service type")
    private QuickSightType type = QuickSightType.fromValue("QuickSight");
    @JsonProperty(value="awsConfig")
    @JsonPropertyDescription(value="AWS credentials configs.")
    @Valid
    @NotNull
    private AWSCredentials awsConfig;
    @JsonProperty(value="awsAccountId")
    @JsonPropertyDescription(value="AWS Account ID")
    @NotNull
    private String awsAccountId;
    @JsonProperty(value="identityType")
    @JsonPropertyDescription(value="The authentication method that the user uses to sign in.")
    private IdentityType identityType = IdentityType.fromValue("IAM");
    @JsonProperty(value="namespace")
    @JsonPropertyDescription(value="The Amazon QuickSight namespace that contains the dashboard IDs in this request ( To be provided when identityType is `ANONYMOUS` )")
    private String namespace;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public QuickSightType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(QuickSightType type) {
        this.type = type;
    }

    public QuickSightConnection withType(QuickSightType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="awsConfig")
    public AWSCredentials getAwsConfig() {
        return this.awsConfig;
    }

    @JsonProperty(value="awsConfig")
    public void setAwsConfig(AWSCredentials awsConfig) {
        this.awsConfig = awsConfig;
    }

    public QuickSightConnection withAwsConfig(AWSCredentials awsConfig) {
        this.awsConfig = awsConfig;
        return this;
    }

    @JsonProperty(value="awsAccountId")
    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    @JsonProperty(value="awsAccountId")
    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public QuickSightConnection withAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
        return this;
    }

    @JsonProperty(value="identityType")
    public IdentityType getIdentityType() {
        return this.identityType;
    }

    @JsonProperty(value="identityType")
    public void setIdentityType(IdentityType identityType) {
        this.identityType = identityType;
    }

    public QuickSightConnection withIdentityType(IdentityType identityType) {
        this.identityType = identityType;
        return this;
    }

    @JsonProperty(value="namespace")
    public String getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public QuickSightConnection withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public QuickSightConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(QuickSightConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("awsConfig");
        sb.append('=');
        sb.append(this.awsConfig == null ? "<null>" : this.awsConfig);
        sb.append(',');
        sb.append("awsAccountId");
        sb.append('=');
        sb.append(this.awsAccountId == null ? "<null>" : this.awsAccountId);
        sb.append(',');
        sb.append("identityType");
        sb.append('=');
        sb.append(this.identityType == null ? "<null>" : this.identityType);
        sb.append(',');
        sb.append("namespace");
        sb.append('=');
        sb.append(this.namespace == null ? "<null>" : this.namespace);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.awsAccountId == null ? 0 : this.awsAccountId.hashCode());
        result = result * 31 + (this.awsConfig == null ? 0 : this.awsConfig.hashCode());
        result = result * 31 + (this.identityType == null ? 0 : this.identityType.hashCode());
        result = result * 31 + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof QuickSightConnection)) {
            return false;
        }
        QuickSightConnection rhs = (QuickSightConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.awsAccountId == rhs.awsAccountId || this.awsAccountId != null && this.awsAccountId.equals(rhs.awsAccountId)) && (this.awsConfig == rhs.awsConfig || this.awsConfig != null && this.awsConfig.equals(rhs.awsConfig)) && (this.identityType == rhs.identityType || this.identityType != null && this.identityType.equals((Object)rhs.identityType)) && (this.namespace == rhs.namespace || this.namespace != null && this.namespace.equals(rhs.namespace)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type));
    }

    public static enum QuickSightType {
        QUICK_SIGHT("QuickSight");

        private final String value;
        private static final Map<String, QuickSightType> CONSTANTS;

        private QuickSightType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static QuickSightType fromValue(String value) {
            QuickSightType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, QuickSightType>();
            for (QuickSightType c : QuickSightType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum IdentityType {
        IAM("IAM"),
        QUICKSIGHT("QUICKSIGHT"),
        ANONYMOUS("ANONYMOUS");

        private final String value;
        private static final Map<String, IdentityType> CONSTANTS;

        private IdentityType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static IdentityType fromValue(String value) {
            IdentityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, IdentityType>();
            for (IdentityType c : IdentityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

