/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.secrets;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import org.openmetadata.schema.security.secrets.Parameters;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"secretsManager", "parameters"})
public class SecretsManagerConfiguration {
    @JsonProperty(value="secretsManager")
    @JsonPropertyDescription(value="OpenMetadata Secrets Manager Provider. Make sure to configure the same secrets manager providers as the ones configured on the OpenMetadata server.")
    private SecretsManagerProvider secretsManager = SecretsManagerProvider.fromValue("noop");
    @JsonProperty(value="parameters")
    @JsonPropertyDescription(value="Extra parameters used by the Secrets Manager implementation.")
    @Valid
    private Parameters parameters;

    @JsonProperty(value="secretsManager")
    public SecretsManagerProvider getSecretsManager() {
        return this.secretsManager;
    }

    @JsonProperty(value="secretsManager")
    public void setSecretsManager(SecretsManagerProvider secretsManager) {
        this.secretsManager = secretsManager;
    }

    public SecretsManagerConfiguration withSecretsManager(SecretsManagerProvider secretsManager) {
        this.secretsManager = secretsManager;
        return this;
    }

    @JsonProperty(value="parameters")
    public Parameters getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public SecretsManagerConfiguration withParameters(Parameters parameters) {
        this.parameters = parameters;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SecretsManagerConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("secretsManager");
        sb.append('=');
        sb.append(this.secretsManager == null ? "<null>" : this.secretsManager);
        sb.append(',');
        sb.append("parameters");
        sb.append('=');
        sb.append(this.parameters == null ? "<null>" : this.parameters);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.secretsManager == null ? 0 : this.secretsManager.hashCode());
        result = result * 31 + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SecretsManagerConfiguration)) {
            return false;
        }
        SecretsManagerConfiguration rhs = (SecretsManagerConfiguration)other;
        return (this.secretsManager == rhs.secretsManager || this.secretsManager != null && this.secretsManager.equals((Object)rhs.secretsManager)) && (this.parameters == rhs.parameters || this.parameters != null && this.parameters.equals(rhs.parameters));
    }
}

