/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"secretKey", "audience"})
public class GoogleSSOClientConfig {
    @JsonProperty(value="secretKey")
    @JsonPropertyDescription(value="Google SSO client secret key path or contents.")
    @PasswordField
    @NotNull
    private String secretKey;
    @JsonProperty(value="audience")
    @JsonPropertyDescription(value="Google SSO audience URL")
    private String audience = "https://www.googleapis.com/oauth2/v4/token";

    @JsonProperty(value="secretKey")
    @PasswordField
    public String getSecretKey() {
        return this.secretKey;
    }

    @JsonProperty(value="secretKey")
    @PasswordField
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public GoogleSSOClientConfig withSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @JsonProperty(value="audience")
    public String getAudience() {
        return this.audience;
    }

    @JsonProperty(value="audience")
    public void setAudience(String audience) {
        this.audience = audience;
    }

    public GoogleSSOClientConfig withAudience(String audience) {
        this.audience = audience;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GoogleSSOClientConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("secretKey");
        sb.append('=');
        sb.append(this.secretKey == null ? "<null>" : this.secretKey);
        sb.append(',');
        sb.append("audience");
        sb.append('=');
        sb.append(this.audience == null ? "<null>" : this.audience);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.secretKey == null ? 0 : this.secretKey.hashCode());
        result = result * 31 + (this.audience == null ? 0 : this.audience.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GoogleSSOClientConfig)) {
            return false;
        }
        GoogleSSOClientConfig rhs = (GoogleSSOClientConfig)other;
        return (this.secretKey == rhs.secretKey || this.secretKey != null && this.secretKey.equals(rhs.secretKey)) && (this.audience == rhs.audience || this.audience != null && this.audience.equals(rhs.audience));
    }
}

