/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"clientSecret", "authority", "clientId", "scopes"})
public class AzureSSOClientConfig {
    @JsonProperty(value="clientSecret")
    @JsonPropertyDescription(value="Azure SSO client secret key")
    @PasswordField
    @NotNull
    private String clientSecret;
    @JsonProperty(value="authority")
    @JsonPropertyDescription(value="Azure SSO Authority")
    @NotNull
    private String authority;
    @JsonProperty(value="clientId")
    @JsonPropertyDescription(value="Azure Client ID.")
    @NotNull
    private String clientId;
    @JsonProperty(value="scopes")
    @JsonPropertyDescription(value="Azure Client ID.")
    @Valid
    @NotNull
    private List<String> scopes = new ArrayList<String>();

    @JsonProperty(value="clientSecret")
    @PasswordField
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="clientSecret")
    @PasswordField
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public AzureSSOClientConfig withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @JsonProperty(value="authority")
    public String getAuthority() {
        return this.authority;
    }

    @JsonProperty(value="authority")
    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public AzureSSOClientConfig withAuthority(String authority) {
        this.authority = authority;
        return this;
    }

    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public AzureSSOClientConfig withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty(value="scopes")
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public AzureSSOClientConfig withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AzureSSOClientConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("clientSecret");
        sb.append('=');
        sb.append(this.clientSecret == null ? "<null>" : this.clientSecret);
        sb.append(',');
        sb.append("authority");
        sb.append('=');
        sb.append(this.authority == null ? "<null>" : this.authority);
        sb.append(',');
        sb.append("clientId");
        sb.append('=');
        sb.append(this.clientId == null ? "<null>" : this.clientId);
        sb.append(',');
        sb.append("scopes");
        sb.append('=');
        sb.append(this.scopes == null ? "<null>" : this.scopes);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.clientSecret == null ? 0 : this.clientSecret.hashCode());
        result = result * 31 + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = result * 31 + (this.scopes == null ? 0 : this.scopes.hashCode());
        result = result * 31 + (this.authority == null ? 0 : this.authority.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AzureSSOClientConfig)) {
            return false;
        }
        AzureSSOClientConfig rhs = (AzureSSOClientConfig)other;
        return (this.clientSecret == rhs.clientSecret || this.clientSecret != null && this.clientSecret.equals(rhs.clientSecret)) && (this.clientId == rhs.clientId || this.clientId != null && this.clientId.equals(rhs.clientId)) && (this.scopes == rhs.scopes || this.scopes != null && this.scopes.equals(rhs.scopes)) && (this.authority == rhs.authority || this.authority != null && this.authority.equals(rhs.authority));
    }
}

