/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.metadataIngestion.OpenMetadataWorkflowConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "openMetadataWorkflowConfig"})
public class Workflow {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) String name;
    @JsonProperty(value="openMetadataWorkflowConfig")
    @JsonPropertyDescription(value="OpenMetadata Ingestion Workflow Config.")
    @Valid
    private OpenMetadataWorkflowConfig openMetadataWorkflowConfig;

    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public Workflow withId(UUID id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Workflow withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="openMetadataWorkflowConfig")
    public OpenMetadataWorkflowConfig getOpenMetadataWorkflowConfig() {
        return this.openMetadataWorkflowConfig;
    }

    @JsonProperty(value="openMetadataWorkflowConfig")
    public void setOpenMetadataWorkflowConfig(OpenMetadataWorkflowConfig openMetadataWorkflowConfig) {
        this.openMetadataWorkflowConfig = openMetadataWorkflowConfig;
    }

    public Workflow withOpenMetadataWorkflowConfig(OpenMetadataWorkflowConfig openMetadataWorkflowConfig) {
        this.openMetadataWorkflowConfig = openMetadataWorkflowConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Workflow.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("openMetadataWorkflowConfig");
        sb.append('=');
        sb.append(this.openMetadataWorkflowConfig == null ? "<null>" : this.openMetadataWorkflowConfig);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.openMetadataWorkflowConfig == null ? 0 : this.openMetadataWorkflowConfig.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Workflow)) {
            return false;
        }
        Workflow rhs = (Workflow)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.openMetadataWorkflowConfig == rhs.openMetadataWorkflowConfig || this.openMetadataWorkflowConfig != null && this.openMetadataWorkflowConfig.equals(rhs.openMetadataWorkflowConfig));
    }
}

