/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.metadataIngestion.FilterPattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "includeLineage", "pipelineFilterPattern", "markDeletedPipelines", "includeTags"})
public class PipelineServiceMetadataPipeline {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Pipeline Source Config Metadata Pipeline type")
    private PipelineMetadataConfigType type = PipelineMetadataConfigType.fromValue("PipelineMetadata");
    @JsonProperty(value="includeLineage")
    @JsonPropertyDescription(value="Optional configuration to turn off fetching lineage from pipelines.")
    private Boolean includeLineage = true;
    @JsonProperty(value="pipelineFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern pipelineFilterPattern;
    @JsonProperty(value="markDeletedPipelines")
    @JsonPropertyDescription(value="Optional configuration to soft delete Pipelines in OpenMetadata if the source Pipelines are deleted. Also, if the Pipeline is deleted, all the associated entities like lineage, etc., with that Pipeline will be deleted")
    private Boolean markDeletedPipelines = true;
    @JsonProperty(value="includeTags")
    @JsonPropertyDescription(value="Optional configuration to toggle the tags ingestion.")
    private Boolean includeTags = true;

    @JsonProperty(value="type")
    public PipelineMetadataConfigType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(PipelineMetadataConfigType type) {
        this.type = type;
    }

    public PipelineServiceMetadataPipeline withType(PipelineMetadataConfigType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="includeLineage")
    public Boolean getIncludeLineage() {
        return this.includeLineage;
    }

    @JsonProperty(value="includeLineage")
    public void setIncludeLineage(Boolean includeLineage) {
        this.includeLineage = includeLineage;
    }

    public PipelineServiceMetadataPipeline withIncludeLineage(Boolean includeLineage) {
        this.includeLineage = includeLineage;
        return this;
    }

    @JsonProperty(value="pipelineFilterPattern")
    public FilterPattern getPipelineFilterPattern() {
        return this.pipelineFilterPattern;
    }

    @JsonProperty(value="pipelineFilterPattern")
    public void setPipelineFilterPattern(FilterPattern pipelineFilterPattern) {
        this.pipelineFilterPattern = pipelineFilterPattern;
    }

    public PipelineServiceMetadataPipeline withPipelineFilterPattern(FilterPattern pipelineFilterPattern) {
        this.pipelineFilterPattern = pipelineFilterPattern;
        return this;
    }

    @JsonProperty(value="markDeletedPipelines")
    public Boolean getMarkDeletedPipelines() {
        return this.markDeletedPipelines;
    }

    @JsonProperty(value="markDeletedPipelines")
    public void setMarkDeletedPipelines(Boolean markDeletedPipelines) {
        this.markDeletedPipelines = markDeletedPipelines;
    }

    public PipelineServiceMetadataPipeline withMarkDeletedPipelines(Boolean markDeletedPipelines) {
        this.markDeletedPipelines = markDeletedPipelines;
        return this;
    }

    @JsonProperty(value="includeTags")
    public Boolean getIncludeTags() {
        return this.includeTags;
    }

    @JsonProperty(value="includeTags")
    public void setIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
    }

    public PipelineServiceMetadataPipeline withIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PipelineServiceMetadataPipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("includeLineage");
        sb.append('=');
        sb.append(this.includeLineage == null ? "<null>" : this.includeLineage);
        sb.append(',');
        sb.append("pipelineFilterPattern");
        sb.append('=');
        sb.append(this.pipelineFilterPattern == null ? "<null>" : this.pipelineFilterPattern);
        sb.append(',');
        sb.append("markDeletedPipelines");
        sb.append('=');
        sb.append(this.markDeletedPipelines == null ? "<null>" : this.markDeletedPipelines);
        sb.append(',');
        sb.append("includeTags");
        sb.append('=');
        sb.append(this.includeTags == null ? "<null>" : this.includeTags);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.includeLineage == null ? 0 : this.includeLineage.hashCode());
        result = result * 31 + (this.pipelineFilterPattern == null ? 0 : this.pipelineFilterPattern.hashCode());
        result = result * 31 + (this.markDeletedPipelines == null ? 0 : this.markDeletedPipelines.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.includeTags == null ? 0 : this.includeTags.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof PipelineServiceMetadataPipeline)) {
            return false;
        }
        PipelineServiceMetadataPipeline rhs = (PipelineServiceMetadataPipeline)other;
        return (this.includeLineage == rhs.includeLineage || this.includeLineage != null && this.includeLineage.equals(rhs.includeLineage)) && (this.pipelineFilterPattern == rhs.pipelineFilterPattern || this.pipelineFilterPattern != null && this.pipelineFilterPattern.equals(rhs.pipelineFilterPattern)) && (this.markDeletedPipelines == rhs.markDeletedPipelines || this.markDeletedPipelines != null && this.markDeletedPipelines.equals(rhs.markDeletedPipelines)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.includeTags == rhs.includeTags || this.includeTags != null && this.includeTags.equals(rhs.includeTags));
    }

    public static enum PipelineMetadataConfigType {
        PIPELINE_METADATA("PipelineMetadata");

        private final String value;
        private static final Map<String, PipelineMetadataConfigType> CONSTANTS;

        private PipelineMetadataConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static PipelineMetadataConfigType fromValue(String value) {
            PipelineMetadataConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, PipelineMetadataConfigType>();
            for (PipelineMetadataConfigType c : PipelineMetadataConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

