/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.metadataIngestion.BulkSink;
import org.openmetadata.schema.metadataIngestion.Processor;
import org.openmetadata.schema.metadataIngestion.Sink;
import org.openmetadata.schema.metadataIngestion.Source;
import org.openmetadata.schema.metadataIngestion.Stage;
import org.openmetadata.schema.metadataIngestion.WorkflowConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"source", "processor", "sink", "stage", "bulkSink", "workflowConfig", "ingestionPipelineFQN", "pipelineRunId"})
public class OpenMetadataWorkflowConfig {
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="Configuration for Source component in OpenMetadata Ingestion Framework.")
    @Valid
    @NotNull
    private Source source;
    @JsonProperty(value="processor")
    @JsonPropertyDescription(value="Configuration for Processor Component in the OpenMetadata Ingestion Framework.")
    @Valid
    private Processor processor;
    @JsonProperty(value="sink")
    @JsonPropertyDescription(value="Configuration for Sink Component in the OpenMetadata Ingestion Framework.")
    @Valid
    private Sink sink;
    @JsonProperty(value="stage")
    @JsonPropertyDescription(value="Configuration for Stage Component in the OpenMetadata Ingestion Framework.")
    @Valid
    private Stage stage;
    @JsonProperty(value="bulkSink")
    @JsonPropertyDescription(value="Configuration for BulkSink Component in the OpenMetadata Ingestion Framework.")
    @Valid
    private BulkSink bulkSink;
    @JsonProperty(value="workflowConfig")
    @JsonPropertyDescription(value="Configuration for the entire Ingestion Workflow.")
    @Valid
    @NotNull
    private WorkflowConfig workflowConfig;
    @JsonProperty(value="ingestionPipelineFQN")
    @JsonPropertyDescription(value="Fully qualified name of ingestion pipeline, used to identify the current ingestion pipeline")
    private String ingestionPipelineFQN;
    @JsonProperty(value="pipelineRunId")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID pipelineRunId;

    @JsonProperty(value="source")
    public Source getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(Source source) {
        this.source = source;
    }

    public OpenMetadataWorkflowConfig withSource(Source source) {
        this.source = source;
        return this;
    }

    @JsonProperty(value="processor")
    public Processor getProcessor() {
        return this.processor;
    }

    @JsonProperty(value="processor")
    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public OpenMetadataWorkflowConfig withProcessor(Processor processor) {
        this.processor = processor;
        return this;
    }

    @JsonProperty(value="sink")
    public Sink getSink() {
        return this.sink;
    }

    @JsonProperty(value="sink")
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    public OpenMetadataWorkflowConfig withSink(Sink sink) {
        this.sink = sink;
        return this;
    }

    @JsonProperty(value="stage")
    public Stage getStage() {
        return this.stage;
    }

    @JsonProperty(value="stage")
    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public OpenMetadataWorkflowConfig withStage(Stage stage) {
        this.stage = stage;
        return this;
    }

    @JsonProperty(value="bulkSink")
    public BulkSink getBulkSink() {
        return this.bulkSink;
    }

    @JsonProperty(value="bulkSink")
    public void setBulkSink(BulkSink bulkSink) {
        this.bulkSink = bulkSink;
    }

    public OpenMetadataWorkflowConfig withBulkSink(BulkSink bulkSink) {
        this.bulkSink = bulkSink;
        return this;
    }

    @JsonProperty(value="workflowConfig")
    public WorkflowConfig getWorkflowConfig() {
        return this.workflowConfig;
    }

    @JsonProperty(value="workflowConfig")
    public void setWorkflowConfig(WorkflowConfig workflowConfig) {
        this.workflowConfig = workflowConfig;
    }

    public OpenMetadataWorkflowConfig withWorkflowConfig(WorkflowConfig workflowConfig) {
        this.workflowConfig = workflowConfig;
        return this;
    }

    @JsonProperty(value="ingestionPipelineFQN")
    public String getIngestionPipelineFQN() {
        return this.ingestionPipelineFQN;
    }

    @JsonProperty(value="ingestionPipelineFQN")
    public void setIngestionPipelineFQN(String ingestionPipelineFQN) {
        this.ingestionPipelineFQN = ingestionPipelineFQN;
    }

    public OpenMetadataWorkflowConfig withIngestionPipelineFQN(String ingestionPipelineFQN) {
        this.ingestionPipelineFQN = ingestionPipelineFQN;
        return this;
    }

    @JsonProperty(value="pipelineRunId")
    public UUID getPipelineRunId() {
        return this.pipelineRunId;
    }

    @JsonProperty(value="pipelineRunId")
    public void setPipelineRunId(UUID pipelineRunId) {
        this.pipelineRunId = pipelineRunId;
    }

    public OpenMetadataWorkflowConfig withPipelineRunId(UUID pipelineRunId) {
        this.pipelineRunId = pipelineRunId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OpenMetadataWorkflowConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("source");
        sb.append('=');
        sb.append(this.source == null ? "<null>" : this.source);
        sb.append(',');
        sb.append("processor");
        sb.append('=');
        sb.append(this.processor == null ? "<null>" : this.processor);
        sb.append(',');
        sb.append("sink");
        sb.append('=');
        sb.append(this.sink == null ? "<null>" : this.sink);
        sb.append(',');
        sb.append("stage");
        sb.append('=');
        sb.append(this.stage == null ? "<null>" : this.stage);
        sb.append(',');
        sb.append("bulkSink");
        sb.append('=');
        sb.append(this.bulkSink == null ? "<null>" : this.bulkSink);
        sb.append(',');
        sb.append("workflowConfig");
        sb.append('=');
        sb.append(this.workflowConfig == null ? "<null>" : this.workflowConfig);
        sb.append(',');
        sb.append("ingestionPipelineFQN");
        sb.append('=');
        sb.append(this.ingestionPipelineFQN == null ? "<null>" : this.ingestionPipelineFQN);
        sb.append(',');
        sb.append("pipelineRunId");
        sb.append('=');
        sb.append(this.pipelineRunId == null ? "<null>" : this.pipelineRunId);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.stage == null ? 0 : this.stage.hashCode());
        result = result * 31 + (this.sink == null ? 0 : this.sink.hashCode());
        result = result * 31 + (this.bulkSink == null ? 0 : this.bulkSink.hashCode());
        result = result * 31 + (this.pipelineRunId == null ? 0 : this.pipelineRunId.hashCode());
        result = result * 31 + (this.workflowConfig == null ? 0 : this.workflowConfig.hashCode());
        result = result * 31 + (this.source == null ? 0 : this.source.hashCode());
        result = result * 31 + (this.ingestionPipelineFQN == null ? 0 : this.ingestionPipelineFQN.hashCode());
        result = result * 31 + (this.processor == null ? 0 : this.processor.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OpenMetadataWorkflowConfig)) {
            return false;
        }
        OpenMetadataWorkflowConfig rhs = (OpenMetadataWorkflowConfig)other;
        return (this.stage == rhs.stage || this.stage != null && this.stage.equals(rhs.stage)) && (this.sink == rhs.sink || this.sink != null && this.sink.equals(rhs.sink)) && (this.bulkSink == rhs.bulkSink || this.bulkSink != null && this.bulkSink.equals(rhs.bulkSink)) && (this.pipelineRunId == rhs.pipelineRunId || this.pipelineRunId != null && this.pipelineRunId.equals(rhs.pipelineRunId)) && (this.workflowConfig == rhs.workflowConfig || this.workflowConfig != null && this.workflowConfig.equals(rhs.workflowConfig)) && (this.source == rhs.source || this.source != null && this.source.equals(rhs.source)) && (this.ingestionPipelineFQN == rhs.ingestionPipelineFQN || this.ingestionPipelineFQN != null && this.ingestionPipelineFQN.equals(rhs.ingestionPipelineFQN)) && (this.processor == rhs.processor || this.processor != null && this.processor.equals(rhs.processor));
    }
}

