/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.metadataIngestion.FilterPattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "dashboardFilterPattern", "chartFilterPattern", "dbServiceNames", "overrideOwner", "markDeletedDashboards", "includeTags"})
public class DashboardServiceMetadataPipeline {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Dashboard Source Config Metadata Pipeline type")
    private DashboardMetadataConfigType type = DashboardMetadataConfigType.fromValue("DashboardMetadata");
    @JsonProperty(value="dashboardFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern dashboardFilterPattern;
    @JsonProperty(value="chartFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern chartFilterPattern;
    @JsonProperty(value="dbServiceNames")
    @JsonPropertyDescription(value="List of Database Service Name for creation of lineage")
    @Valid
    private List<Object> dbServiceNames = new ArrayList<Object>();
    @JsonProperty(value="overrideOwner")
    @JsonPropertyDescription(value="Enabling this flag will override current owner with new owner from the source,if that is fetched during metadata ingestion. Kindly make to keep it enabled, to get the owner, for first time metadata ingestion.")
    private Boolean overrideOwner = false;
    @JsonProperty(value="markDeletedDashboards")
    @JsonPropertyDescription(value="Optional configuration to soft delete dashboards in OpenMetadata if the source dashboards are deleted. Also, if the dashboard is deleted, all the associated entities like lineage, etc., with that dashboard will be deleted")
    private Boolean markDeletedDashboards = true;
    @JsonProperty(value="includeTags")
    @JsonPropertyDescription(value="Optional configuration to toggle the tags ingestion.")
    private Boolean includeTags = true;

    @JsonProperty(value="type")
    public DashboardMetadataConfigType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(DashboardMetadataConfigType type) {
        this.type = type;
    }

    public DashboardServiceMetadataPipeline withType(DashboardMetadataConfigType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="dashboardFilterPattern")
    public FilterPattern getDashboardFilterPattern() {
        return this.dashboardFilterPattern;
    }

    @JsonProperty(value="dashboardFilterPattern")
    public void setDashboardFilterPattern(FilterPattern dashboardFilterPattern) {
        this.dashboardFilterPattern = dashboardFilterPattern;
    }

    public DashboardServiceMetadataPipeline withDashboardFilterPattern(FilterPattern dashboardFilterPattern) {
        this.dashboardFilterPattern = dashboardFilterPattern;
        return this;
    }

    @JsonProperty(value="chartFilterPattern")
    public FilterPattern getChartFilterPattern() {
        return this.chartFilterPattern;
    }

    @JsonProperty(value="chartFilterPattern")
    public void setChartFilterPattern(FilterPattern chartFilterPattern) {
        this.chartFilterPattern = chartFilterPattern;
    }

    public DashboardServiceMetadataPipeline withChartFilterPattern(FilterPattern chartFilterPattern) {
        this.chartFilterPattern = chartFilterPattern;
        return this;
    }

    @JsonProperty(value="dbServiceNames")
    public List<Object> getDbServiceNames() {
        return this.dbServiceNames;
    }

    @JsonProperty(value="dbServiceNames")
    public void setDbServiceNames(List<Object> dbServiceNames) {
        this.dbServiceNames = dbServiceNames;
    }

    public DashboardServiceMetadataPipeline withDbServiceNames(List<Object> dbServiceNames) {
        this.dbServiceNames = dbServiceNames;
        return this;
    }

    @JsonProperty(value="overrideOwner")
    public Boolean getOverrideOwner() {
        return this.overrideOwner;
    }

    @JsonProperty(value="overrideOwner")
    public void setOverrideOwner(Boolean overrideOwner) {
        this.overrideOwner = overrideOwner;
    }

    public DashboardServiceMetadataPipeline withOverrideOwner(Boolean overrideOwner) {
        this.overrideOwner = overrideOwner;
        return this;
    }

    @JsonProperty(value="markDeletedDashboards")
    public Boolean getMarkDeletedDashboards() {
        return this.markDeletedDashboards;
    }

    @JsonProperty(value="markDeletedDashboards")
    public void setMarkDeletedDashboards(Boolean markDeletedDashboards) {
        this.markDeletedDashboards = markDeletedDashboards;
    }

    public DashboardServiceMetadataPipeline withMarkDeletedDashboards(Boolean markDeletedDashboards) {
        this.markDeletedDashboards = markDeletedDashboards;
        return this;
    }

    @JsonProperty(value="includeTags")
    public Boolean getIncludeTags() {
        return this.includeTags;
    }

    @JsonProperty(value="includeTags")
    public void setIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
    }

    public DashboardServiceMetadataPipeline withIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DashboardServiceMetadataPipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("dashboardFilterPattern");
        sb.append('=');
        sb.append(this.dashboardFilterPattern == null ? "<null>" : this.dashboardFilterPattern);
        sb.append(',');
        sb.append("chartFilterPattern");
        sb.append('=');
        sb.append(this.chartFilterPattern == null ? "<null>" : this.chartFilterPattern);
        sb.append(',');
        sb.append("dbServiceNames");
        sb.append('=');
        sb.append(this.dbServiceNames == null ? "<null>" : this.dbServiceNames);
        sb.append(',');
        sb.append("overrideOwner");
        sb.append('=');
        sb.append(this.overrideOwner == null ? "<null>" : this.overrideOwner);
        sb.append(',');
        sb.append("markDeletedDashboards");
        sb.append('=');
        sb.append(this.markDeletedDashboards == null ? "<null>" : this.markDeletedDashboards);
        sb.append(',');
        sb.append("includeTags");
        sb.append('=');
        sb.append(this.includeTags == null ? "<null>" : this.includeTags);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.dashboardFilterPattern == null ? 0 : this.dashboardFilterPattern.hashCode());
        result = result * 31 + (this.dbServiceNames == null ? 0 : this.dbServiceNames.hashCode());
        result = result * 31 + (this.includeTags == null ? 0 : this.includeTags.hashCode());
        result = result * 31 + (this.overrideOwner == null ? 0 : this.overrideOwner.hashCode());
        result = result * 31 + (this.chartFilterPattern == null ? 0 : this.chartFilterPattern.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.markDeletedDashboards == null ? 0 : this.markDeletedDashboards.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DashboardServiceMetadataPipeline)) {
            return false;
        }
        DashboardServiceMetadataPipeline rhs = (DashboardServiceMetadataPipeline)other;
        return (this.dashboardFilterPattern == rhs.dashboardFilterPattern || this.dashboardFilterPattern != null && this.dashboardFilterPattern.equals(rhs.dashboardFilterPattern)) && (this.dbServiceNames == rhs.dbServiceNames || this.dbServiceNames != null && this.dbServiceNames.equals(rhs.dbServiceNames)) && (this.includeTags == rhs.includeTags || this.includeTags != null && this.includeTags.equals(rhs.includeTags)) && (this.overrideOwner == rhs.overrideOwner || this.overrideOwner != null && this.overrideOwner.equals(rhs.overrideOwner)) && (this.chartFilterPattern == rhs.chartFilterPattern || this.chartFilterPattern != null && this.chartFilterPattern.equals(rhs.chartFilterPattern)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.markDeletedDashboards == rhs.markDeletedDashboards || this.markDeletedDashboards != null && this.markDeletedDashboards.equals(rhs.markDeletedDashboards));
    }

    public static enum DashboardMetadataConfigType {
        DASHBOARD_METADATA("DashboardMetadata");

        private final String value;
        private static final Map<String, DashboardMetadataConfigType> CONSTANTS;

        private DashboardMetadataConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DashboardMetadataConfigType fromValue(String value) {
            DashboardMetadataConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DashboardMetadataConfigType>();
            for (DashboardMetadataConfigType c : DashboardMetadataConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

