/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Category {
    Field("field"),
    Entity("entity");

    private final String value;
    private static final Map<String, Category> CONSTANTS;

    private Category(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Category fromValue(String value) {
        Category constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Category>();
        for (Category c : Category.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

