/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.services.ingestionPipelines;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum PipelineType {
    METADATA("metadata"),
    USAGE("usage"),
    LINEAGE("lineage"),
    PROFILER("profiler"),
    TEST_SUITE("TestSuite"),
    DATA_INSIGHT("dataInsight"),
    ELASTIC_SEARCH_REINDEX("elasticSearchReindex"),
    DBT("dbt");

    private final String value;
    private static final Map<String, PipelineType> CONSTANTS;

    private PipelineType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static PipelineType fromValue(String value) {
        PipelineType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, PipelineType>();
        for (PipelineType c : PipelineType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

