/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.entity.events.EventFilterRule;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"resources", "rules"})
public class FilteringRules {
    @JsonProperty(value="resources")
    @JsonPropertyDescription(value="Defines a list of resources that triggers the Event Subscription, Eg All, User, Teams etc.")
    @Valid
    @NotNull
    private List<String> resources = new ArrayList<String>();
    @JsonProperty(value="rules")
    @JsonPropertyDescription(value="A set of filter rules associated with the Alert.")
    @Valid
    private List<EventFilterRule> rules = new ArrayList<EventFilterRule>();

    @JsonProperty(value="resources")
    public List<String> getResources() {
        return this.resources;
    }

    @JsonProperty(value="resources")
    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public FilteringRules withResources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    @JsonProperty(value="rules")
    public List<EventFilterRule> getRules() {
        return this.rules;
    }

    @JsonProperty(value="rules")
    public void setRules(List<EventFilterRule> rules) {
        this.rules = rules;
    }

    public FilteringRules withRules(List<EventFilterRule> rules) {
        this.rules = rules;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FilteringRules.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("resources");
        sb.append('=');
        sb.append(this.resources == null ? "<null>" : this.resources);
        sb.append(',');
        sb.append("rules");
        sb.append('=');
        sb.append(this.rules == null ? "<null>" : this.rules);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.resources == null ? 0 : this.resources.hashCode());
        result = result * 31 + (this.rules == null ? 0 : this.rules.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FilteringRules)) {
            return false;
        }
        FilteringRules rhs = (FilteringRules)other;
        return (this.resources == rhs.resources || this.resources != null && this.resources.equals(rhs.resources)) && (this.rules == rhs.rules || this.rules != null && this.rules.equals(rhs.rules));
    }
}

