/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "fullyQualifiedName", "description", "effect", "condition"})
public class EventFilterRule {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of this Event Filter.")
    private String name;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    private @Size(min=1, max=256) String fullyQualifiedName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="effect")
    @NotNull
    private Effect effect;
    @JsonProperty(value="condition")
    @JsonPropertyDescription(value="Expression in SpEL.")
    @NotNull
    private String condition;

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public EventFilterRule withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public EventFilterRule withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public EventFilterRule withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="effect")
    public Effect getEffect() {
        return this.effect;
    }

    @JsonProperty(value="effect")
    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    public EventFilterRule withEffect(Effect effect) {
        this.effect = effect;
        return this;
    }

    @JsonProperty(value="condition")
    public String getCondition() {
        return this.condition;
    }

    @JsonProperty(value="condition")
    public void setCondition(String condition) {
        this.condition = condition;
    }

    public EventFilterRule withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EventFilterRule.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("effect");
        sb.append('=');
        sb.append(this.effect == null ? "<null>" : this.effect);
        sb.append(',');
        sb.append("condition");
        sb.append('=');
        sb.append(this.condition == null ? "<null>" : this.condition);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.condition == null ? 0 : this.condition.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.effect == null ? 0 : this.effect.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EventFilterRule)) {
            return false;
        }
        EventFilterRule rhs = (EventFilterRule)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.condition == rhs.condition || this.condition != null && this.condition.equals(rhs.condition)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.effect == rhs.effect || this.effect != null && this.effect.equals((Object)rhs.effect));
    }

    public static enum Effect {
        INCLUDE("include"),
        EXCLUDE("exclude");

        private final String value;
        private static final Map<String, Effect> CONSTANTS;

        private Effect(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Effect fromValue(String value) {
            Effect constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Effect>();
            for (Effect c : Effect.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

